% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries1D.r
\name{timeseries1D}
\alias{timeseries1D}
\title{Generate a 1D Langevin process}
\usage{
timeseries1D(
  N,
  startpoint = 0,
  d13 = 0,
  d12 = 0,
  d11 = -1,
  d10 = 0,
  d22 = 0,
  d21 = 0,
  d20 = 1,
  sf = 1000,
  dt = 0
)
}
\arguments{
\item{N}{a scalar denoting the length of the time-series to generate.}

\item{startpoint}{a scalar denoting the starting point of the time series.}

\item{d13, d12, d11, d10}{scalars denoting the coefficients for the drift polynomial.}

\item{d22, d21, d20}{scalars denoting the coefficients for the diffusion polynomial.}

\item{sf}{a scalar denoting the sampling frequency.}

\item{dt}{a scalar denoting the maximal time step of integration. Default
\code{dt=0} yields \code{dt=1/sf}.}
}
\value{
\code{timeseries1D} returns a time-series object of length
\code{N} with the generated time-series.
}
\description{
\code{timeseries1D} generates a one-dimensional Langevin process using a
simple Euler integration. The drift function is a cubic polynomial, the
diffusion function a quadratic.
}
\examples{
# Generate standardized Ornstein-Uhlenbeck-Process (d11=-1, d20=1)
# with integration time step 0.01 and sampling frequency 1
s <- timeseries1D(N=1e4, sf=1, dt=0.01);
t <- 1:1e4;
plot(t, s, t="l", main=paste("mean:", mean(s), " var:", var(s)));
}
\seealso{
\code{\link{timeseries2D}}
}
\author{
Philip Rinn
}
