% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divisiveHC.details.R
\name{divisiveHC.details}
\alias{divisiveHC.details}
\title{To explain the divisive hierarchical clusterization algorithm by distance and approach.}
\usage{
divisiveHC.details(data, distance, approach)
}
\arguments{
\item{data}{could be a numeric vector, a matrix or a numeric data frame. It will be transformed into matrix and list to be used.}

\item{distance}{is a string. It chooses the distance to use.}

\item{approach}{is a string. It chooses the approach to use.}
}
\value{
A list with the divided clusters. Explanation
}
\description{
To explain the complete divisive hierarchical clusterization algorithm by choosing distance and approach types.
}
\details{
This function is the main part of the divisive hierarchical clusterization method.
It explains the theoretical algorithm step by step.

1 - The function transforms data in useful object to be used.

2 - It creates a cluster that includes every simple elements.

3 - It initializes posible clusters using the initial elements.

4 - It calculates a matrix distance with the clusters created in the 3rd step.

5 - It chooses the maximal distance value and gets the clusters to be divided.

6 - It divides the cluster into two new complementary clusters and updates the clusters list.

6 - It repeats these steps until every cluster can't be divided again. The solution includes every simple cluster.
}
\examples{

a <- c(1,2,1,3,1,4,1,5,1,6)

matrixA <- matrix(a,ncol=2)

dataFrameA <- data.frame(matrixA)

divisiveHC.details(a,'EUC','MAX')

divisiveHC.details(matrixA,'MAN','AVG')

divisiveHC.details(dataFrameA,'CHE','MIN')

}
\author{
Roberto Alcántara \email{roberto.alcantara@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
