% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportion.test.R
\name{proportion.test}
\alias{proportion.test}
\title{Large Sample Test for a Population Proportion}
\usage{
proportion.test(x, n, p0, alternative = "two.sided", alpha = 0.05,
  plot = TRUE, lwd = 1)
}
\arguments{
\item{x}{a positive number indicating the counts of successes or, if number
between 0 and 1, probability of success.}

\item{n}{a single positive integer corresponding with the sample size.}

\item{p0}{a positive number in (0,1) corresponding with the proportion to test.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "\code{two.sided}" (default), "\code{greater}" or "\code{less}".}

\item{alpha}{a single number in (0,1) corresponding with significance level.}

\item{plot}{a logical value indicating whether to display a graph including the test statistic value for the sample, its distribution, the rejection region and p-value.}

\item{lwd}{a single number indicating the line width of the plot.}
}
\value{
A list with class "\code{lstest}" and "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{parameter}{the sample size \code{n}.}
\item{p.value}{the p-value of the test.}
\item{estimate}{the sample proportion.}
\item{null.value}{the value of \code{p0} specified by the null.}
\item{alternative}{a character string describing the alternative.}
\item{method}{a character string indicating the method used.}
\item{data.name}{a character string giving the names of the data.}
\item{alpha}{the significance level.}
\item{dist.name}{a character string indicating the distribution of the test statistic.}
\item{statformula}{a character string with the statistic's formula.}
\item{reject.region}{a character string with the reject region.}
}
\description{
\code{proportion.test} allows to compute a hypothesis test for a population proportion.
}
\details{
Counts of successes and failures must be nonnegative and hence not greater
than the corresponding numbers of trials which must be positive. All finite counts
should be integers. If the number of successes is given, then the proportion estimate is computed.
}
\examples{
x <- rbinom(1, 120, 0.6)
proportion.test(x, 120, 0.5, alternative = "greater")
proportion.test(0.6, 120, 0.5, alternative = "greater")
}
