#' Tidy intensities generated by algorithm so that lights can accept them
#'
#' @param intensities_matrix Matrix of predicted intensities
#' @inheritParams internal.calibCombine
#'
#' @return Maxtrix of intensities which are integers and capped at the maximum possible intensity
#' @keywords internal
#'
internal.tidyIntensities = function(intensities_matrix, calibration_intensities){

  # Round, since the lights only accept integers
  internalMat = round(intensities_matrix)

  # Cap the intensities at maximum intensity of calibration
  maxAllowable = max(calibration_intensities)

  overAllowable = which(internalMat > maxAllowable)
  internalMat[overAllowable] = maxAllowable

  # Set negatives to 0
  under0 = which(internalMat < 0)
  internalMat[under0] = 0

  # Return
  return(internalMat)
}
