% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral_integration.R
\name{spectral_integration}
\alias{spectral_integration}
\title{Integrate spectral irradiance with optional weighting}
\usage{
spectral_integration(
  spectrum,
  wavelength.range = NULL,
  action.spectrum = NULL,
  general.weight = 1
)
}
\arguments{
\item{spectrum}{Tibble with spectral data (1st col: wavelength, 2nd col: SPD values)}

\item{wavelength.range}{Optional integration bounds (length-2 numeric)}

\item{action.spectrum}{Either:
\itemize{
\item Tibble with wavelength and weighting columns
\item Name of built-in spectrum: "photopic", "melanopic", "rhodopic",
"l_cone_opic", "m_cone_opic", "s_cone_opic"
}}

\item{general.weight}{Scalar multiplier or "auto" for built-in efficacies}
}
\value{
Numeric integrated value
}
\description{
Integrates over a given spectrum, optionally over only a portion of the
spectrum, optionally with a weighing function. Can be used to calculate
spectral contributions in certain wavelength ranges, or to calculate
(alphaopically equivalent daylight) illuminance.
}
\details{
The function uses trapezoidal integration and recognizes differing
step-widths in the spectrum. If an action spectrum is used, values of the
action spectrum at the spectral wavelenghts are interpolated with
\code{\link[stats:approxfun]{stats::approx()}}.

The used efficacies for for the auto-weighting are:
\itemize{
\item photopic: 683.0015478
\item melanopic: 1/0.0013262
\item rhodopic: 1/0.0014497
\item l_cone_opic: 1/0.0016289
\item m_cone_opic: 1/0.0014558
\item s_cone_opic: 1/0.0008173
}

This requires input values in W/(m^2) for the spectrum. If it is provided in
other units, the result has to be rescaled afterwards.
}
\examples{
# creating an equal energy spectrum of value 1
spd <- data.frame(wl = 380:780, values = 1)

#integrating over the full spectrum
spectral_integration(spd)

#integrating over wavelengths 400-500 nm
spectral_integration(spd, wavelength.range = c(400, 500))

#calculating the photopic illuminance of an equal energy spectrum with 1 W/(m^2*nm)
spectral_integration(spd, action.spectrum = "photopic", general.weight = "auto")

#calculating the melanopic EDI of an equal energy spectrum with 1 W/(m^2*nm)
spectral_integration(spd, action.spectrum = "melanopic", general.weight = "auto")

# Custom action spectrum
custom_act <- data.frame(wavelength = 400:700, weight = 0.5)
spectral_integration(spd, wavelength.range = c(400,700), 
                     action.spectrum = custom_act, general.weight = 2)
                     
#using a spectrum that is broader then the action spectrum will not change the
#output, as the action spectrum will use zeros beyond its range


}
\seealso{
Other Spectrum: 
\code{\link{normalize_counts}()},
\code{\link{spectral_reconstruction}()}
}
\concept{Spectrum}
