#' @title Delete repeated channel data generated by LC-MS
#' @description
#'channel.delete select one of the channel with largest mean value out of multiple replicated LC-MS cahnnels,
#'    and it returns an edited data frame with no repeated channel and simplified row name.
#'
#'
#' @param data Primary lipidomic data in .csv  format.
#' @param delete.pattern Pattern of characters that needs to be removed.
#' @param group Vector. The group information, recommended to be generated with groupXpert()
#' @param remove Character. The group that needed to be removed.
#'
#' @return Edited data with no repeat channels and simplified row name.
#' @export
#'
#' @examples
#' x1 <- c(1,1,1,1)
#' x2 <- c(1.1,1.2,1.3,1.4)
#' x3 <- c(1,1,1,1)
#' x4 <- c(2,2,2,2)
#' rowNames <- c('PC(14:0/14:1)+AcO_1','PC(14:0/14:1)+AcO_2','PC(16:0/16:1)_1','PC(16:0/16:1)_2')
#' ExampleData <- data.frame(x1,x2,x3,x4, row.names =rowNames)
#' replicate.delete(ExampleData,delete.pattern= c('_\\d','(\\+)AcO'))
#' @export
channel.delete <- function(data, delete.pattern= c('_\\d','(\\+)AcO','_n', '\\(\\d+\\)'), group = NA, remove = NA) {
  data<-na.omit(data)
  lipid<-rownames(data)
  for (pattern in delete.pattern) {
    lipid<-gsub(pattern,'',lipid)
  }
  rn<-lipid
  data$Sample.NAme<-rn
  x<-duplicated(rn)
  rre<-unique(rn[x])
  ids<-c()
  for (everyrep in rre) {
    current_lipid<-data[which(data$Sample.NAme==everyrep),]
    current_lipid<-t(current_lipid[,colnames(current_lipid) != "Sample.NAme"])
    current_lipid<-data.frame(current_lipid,stringsAsFactors = FALSE,check.names = FALSE)
    current_lipid2<-as.data.frame(lapply(current_lipid,as.numeric),row.names = rownames(current_lipid),check.names = FALSE)
    avg<-apply(current_lipid2[which(rownames(current_lipid2)!='Sample.NAme'),], 2, 'mean')
    Max<-names(which(avg==max(avg)))
    id<-ifelse(length(Max)>1,Max[1],Max)
    ids<-c(ids,setdiff(colnames(current_lipid),id))
  }
  data_NR<-data[setdiff(rownames(data),ids),]
  rownames(data_NR)<-data_NR$Sample.NAme
  data_NR <- data_NR[,colnames(data_NR) != "Sample.NAme"]
  data_NR <- na.omit(data_NR)
  if (is.na(group) == FALSE){
  data_NR <- data[,group[names(group) != remove]]
  }
  return(data_NR)
}
