% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{QCplot}
\alias{QCplot}
\title{QCplot()}
\usage{
QCplot(
  data,
  ptype,
  group,
  qcdt,
  box.sample.name = c("default"),
  box.x = "sample",
  box.y = "abundance",
  box.title = "",
  errorbar.show = TRUE,
  group.col = c("default"),
  outlie.col = NA,
  outlie.shape = NA,
  heat.sample.name = c("default"),
  heat.start.col = "white",
  heat.end.col = "#3E8BCA",
  heat.title = "Correlation Heatmap",
  group.show = TRUE,
  range.show = TRUE,
  range.alpha = 0.25,
  shape = TRUE,
  pca.title = "PCA Scores Plot",
  point.size = 3.5,
  point.t.size = 1.5,
  point.t.color = "grey25",
  point.t.overlap = 200,
  marked = c("A", "B", "C"),
  combine = TRUE,
  title.hjust = 0.5,
  title.vjust = 0,
  title.size = 15,
  a.title.size = 13,
  a.text.size = 8,
  a.text.angle = 45,
  a.text.vjust = 1,
  a.text.hjust = 1,
  l.text.size = 11,
  l.title.size = 13,
  margin = c(1, 1, 1, 1),
  unit = "in",
  cellsize = 8,
  interactive = TRUE
)
}
\arguments{
\item{data}{A dataframe storing concentration of lipids between different samples.
The column name should be the sample name and the row name should be the lipid type.
The class of column name and row name should be "character". The class of values should be
"numeric". The row names are recommended to be in a form like "PL(14:0/20:1)" or "LPL(16:1)".
It is highly recommended to input data after normalization.}

\item{ptype}{A vector to define picture types output. The input can include "heatmap",
"PCA" and "boxplot".}

\item{group}{A vector defining which group the replicates belong to.}

\item{qcdt}{A dataframe containing internal labels and their abundance, which is used
to draw quality boxplot. If you don't want to draw the boxplot, the paramenter can
be ignored.}

\item{box.sample.name}{A vector containing the sample names, the length of "box.sample.name"
should equal the number of samples. This parameter can only change the sample name of
boxplot. The default values are the column names of the data input.}

\item{box.x}{The name of the x axis of the boxplot. The default value is "sample".}

\item{box.y}{The name of the x axis of the boxplot. The default value is "abundance".}

\item{box.title}{The picture title of the boxplot. The default value is "".}

\item{errorbar.show}{Whether show the errorbars of the boxplot or not. The default value is "".}

\item{group.col}{A vector containing the colors for each group. The length of "group.col" should equal the
number of the groups. If not input, the color will be default values.}

\item{outlie.col}{The color of outliers. The default value is NA (not show outliers).}

\item{outlie.shape}{The shape of outliers, which can be 1 - 25. The default value is NA (not show outliers).}

\item{heat.sample.name}{A vector containing the sample names, the length of "heat.sample.name"
should equal the number of samples. This parameter can only change the sample name of
heatmap. The default values are the column names of the data input.}

\item{heat.start.col}{The lightest color of the heatmap. The default value is "white".}

\item{heat.end.col}{The deepest color of the heatmap. The default value is "#3E8BCA".}

\item{heat.title}{The picture title of the heatmap. The default value is "Correlation Heatmap".}

\item{group.show}{Whether to show the classification of different groups of the heatmap. The default value is TRUE.}

\item{range.show}{Whether to show the range of PCA plot. The default value is TRUE.}

\item{range.alpha}{The transparency of the range in the PCA, only useful when range.show = TRUE. The default value is 0.25.}

\item{shape}{Whether to classify different groups by shape. The default value is TRUE.}

\item{pca.title}{The picture title of the PCA plot. The default value is "PCA Scores Plot".}

\item{point.size}{The size of points in the PCA plot. The default value is 3.5.}

\item{point.t.size}{The size of texts labeled on points. The default value is 1.5.}

\item{point.t.color}{The color of texts labeled on points. The default value is "grey25".}

\item{point.t.overlap}{To let the texts of points be shown without overlapping. The default value is 200.

If you don't want to show texts labeled on points, please set "point.t.size=0" and "point.t.overlap=0".}

\item{marked}{Only useful when combine = T, it decides the labels on the top left of the picture. The default value
is  c("A", "B","C"). If you don't want to show, use "marked=c("", "","") ".}

\item{combine}{Whether to combine the three plots when ptype = "all". The default value is T. If combine = FALSE,
the three plots will be returned separately.}

\item{title.hjust}{Define the horizontal position of the picture title. The default value is 0.5.}

\item{title.vjust}{Define the vertical position of the picture title. The default value is 0.}

\item{title.size}{Define the size of the picture title. The default value is 15.}

\item{a.title.size}{Define the size of the axis title. The default value is 13.}

\item{a.text.size}{Define the size of the axis text. The default value is 8.}

\item{a.text.angle}{Define the angle of the X axis text of the boxplot, which can be 0 - 360. The default value is 45.}

\item{a.text.vjust}{Define the vertical position of the axis text. The default value is 1.}

\item{a.text.hjust}{Define the horizontal position of the axis text. The default value is 1.}

\item{l.text.size}{Define the size of the legend. The default value is 11.}

\item{l.title.size}{Define the size of the legend. The default value is 13.}

\item{margin}{Define the margin surrounding the plot area of each plot. It should be a vector whose length = 4. The default value is c(0.4,0.4,0.4,0.4).}

\item{unit}{The unit of the "margin" parameter, which can be "mm", "cm", "in", "pt", and "pc". The default value is "in".}

\item{cellsize}{The size of a cell in the heatmap. Default value is 8.}

\item{interactive}{Whether to get an interactive PCA plot or not. Default value is TRUE.}
}
\value{
A correlation heatmap, PCA plot, quality boxplot, or a merged pictures containing
the above three.
}
\description{
A function to exhibit the data quality between different samples, including
correlation heatmap, PCA, and quality boxplot.
}
