% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abundance.R
\name{abundance.summary}
\alias{abundance.summary}
\title{Summarize Abundance Data}
\usage{
abundance.summary(
  data,
  group,
  istotal = FALSE,
  .summary = function(x) mean(x),
  .error = function(x) sd(x)
)
}
\arguments{
\item{data}{The data frame containing abundance data.}

\item{group}{A vector specifying the group membership for each sample.}

\item{istotal}{Logical. If is true, the total summary table of lipid type, carbon number and unsaturation rate will be generated.}

\item{.summary}{A function to summarize abundance data within each group (default is mean).}

\item{.error}{A function to compute error measures within each group (default is standard deviation).}
}
\value{
A data frame summarizing abundance data by species, group, lipid type, carbon number, and unsaturation.
}
\description{
This function summarizes abundance data based on specified groups.
}
