% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_cleaner.R
\name{noridx}
\alias{noridx}
\title{noridx()}
\usage{
noridx(data, radio.data = NULL,
normalization.mode='both',
sample = 1:5, normalize_to = 2:5,
Inlabel=c('PE(17:0/17:0)','PC(17:0/17:0)','PS(14:0/14:0)'),
relative_as_default = TRUE,
relative.mannual = NULL)
}
\arguments{
\item{data}{Data frame, row lipidomics data.}

\item{radio.data}{Data frame. Characteristic of the radio label data.
The row name must be the exact channel name of the label. Molecular mass should be
provided in a column named "Mass". Concentration should be provided in a column named "Concentration(mg/ml)".}

\item{normalization.mode}{Character. "absolute" tp output absolute normalization index
'relative' to output relative normalization index. "both" to output both of them. Default as "both".}

\item{sample}{Vector. Column of sample added with isotope label. Default as 2:5.}

\item{normalize_to}{Vector. The column of samples that used as the standard for normalization.}

\item{Inlabel}{Inlabel Vector. Name of Internal label. Default as c('PE(17:0/17:0)','PC(17:0/17:0)','PS(14:0/14:0)')}

\item{relative_as_default}{Logical, default as TRUE for automatically searching for internal label data.}

\item{relative.mannual}{Vector, the exact channel name (if you want to define the channel of internal label mannually).}
}
\value{
1. normalization.mode='both'. A list of data frames of normalization indexes of the two modes.
2. normalization.mode='absolute' or 'relative'. A data frame of the respective normlaization index.
}
\description{
An integrated function that call nor.relative() and nor.absolute(), for simplifying.
}
