% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.peaksplines.R
\name{plotmodelSelectionEvaluation}
\alias{plotmodelSelectionEvaluation}
\title{Plotting results of Model Evaluation and Selection.}
\usage{
plotmodelSelectionEvaluation(
  lobraModelSelectionObject,
  qualityMeasure,
  title = NULL
)
}
\arguments{
\item{lobraModelSelectionObject}{Object of type LDOmodelselection that was created during the model evaluation. @seealso 'lobraModelSelection'}

\item{qualityMeasure}{List of quality measures to be visualized.}

\item{title}{Title of the plot.}
}
\value{
No return value
}
\description{
Plotting the results of Model Evaluation and Selection. The plot shows a vertical boxplot for each spline tested starting with the best average fit according to the selected quality measure. The label of each spline can be found on the left, the median quality measure on the right. The x-axis denotes the selected quality measure.
}
\examples{
\dontrun{
} 

wd <- tempdir()
data(LoBraExample)
selectedLDO <- selectComponents(ldo, components)
ldoSelect<- lobraModelSelection(selectedLDO, potentialBreaks=c(8, 12), nknots=c(1, 2))

filename<- file.path(wd, "evaluateBestSplineAIC.pdf") ;
grDevices::pdf(filename, width=16, height=8);
  plotmodelSelectionEvaluation(ldoSelect, "AIC", "Best Spline Models");
grDevices::dev.off();
  
qualityMeasure=c("AIC", "BIC", "logLik")
filename<- file.path(wd, "evaluateBestSplineAllMeasures.pdf") ;
grDevices::pdf(filename, width=16, height=8);
oldpar <- par("mfrow")
par(mfrow=c(3,1))
  plotmodelSelectionEvaluation(ldoSelect, qualityMeasure);
par(mfrow = oldpar)
grDevices::dev.off();

}
