% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialLobsterGrid.R
\name{initialLobsterGrid}
\alias{initialLobsterGrid}
\title{This function simulates an arena (or grid) with lobsters in it based on the provided density, size and sex distribution.}
\usage{
initialLobsterGrid(
  nrowgrids,
  ncolgrids,
  unitarea,
  initlambda,
  initD,
  lobsterSizeFile,
  lobsterSexDist
)
}
\arguments{
\item{nrowgrids}{is a numeric value which defines the number of rows of the arena.}

\item{ncolgrids}{is a numeric value which defines the number of columns of the arena.}

\item{unitarea}{is the unit area used for estimating density of lobsters.}

\item{initlambda}{is the density of lobsters at the beginning of simulation.}

\item{initD}{is the dispersion index of lobsters on seabed at the beginning of the simulation.}

\item{lobsterSizeFile}{is a csv file that contains the frequency of lobsters size class.}

\item{lobsterSexDist}{is a list that contains the sex ratio of lobsters. Possible values are M=male, F=female, MM=mature male, BF=berried female)}
}
\value{
Returns x and y coordinates of simulated lobsters at the beginning.
}
\description{
This function simulates an arena (or grid) with lobsters in it based on the provided density, size and sex distribution.
}
