% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/M3JF.R
\name{M3JF}
\alias{M3JF}
\title{Multi-Modal Matrix Joint Factorization}
\usage{
M3JF(WL, lambda = 0.01, theta = 10^-6, k)
}
\arguments{
\item{WL}{a list of multiple modality data matrices}

\item{lambda}{the parameter to set the relative weight of the group sparse constraint}

\item{theta}{threshold for the stopping criteria}

\item{k}{cluster number}
}
\value{
result, a list of 3 elements, the first element is a list comprising the
shared sub-matrix and the modality specific sub-matrices. The second element is
a vector of the clustering result. The third element is a vector of the cost in
each step during optimization.
}
\description{
Multi-Modal Matrix Joint Factorization
}
\examples{
library(InterSIM)
sim.data <- InterSIM(n.sample=500, cluster.sample.prop = c(0.20,0.30,0.27,0.23),
delta.methyl=5, delta.expr=5, delta.protein=5,p.DMP=0.2, p.DEG=NULL,
p.DEP=NULL,sigma.methyl=NULL, sigma.expr=NULL, sigma.protein=NULL,cor.methyl.expr=NULL,
cor.expr.protein=NULL,do.plot=FALSE, sample.cluster=TRUE, feature.cluster=TRUE)
sim.methyl <- sim.data$dat.methyl
sim.expr <- sim.data$dat.expr
sim.protein <- sim.data$dat.protein
temp_data <- list(sim.methyl, sim.expr, sim.protein)
M3JF_res <- M3JF(temp_data,k=4)
}
