% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_screen_sd.R
\name{feature_screen_sd}
\alias{feature_screen_sd}
\title{Screen the cluster related features via hypergeometric test p value and distribution standard derivation}
\usage{
feature_screen_sd(feature_list, sig_num = 20)
}
\arguments{
\item{feature_list}{a data list, which is the output of feature_selection function}

\item{sig_num}{the number of significant features for each cluster}
}
\value{
selected_features, a list the same long as the cluster number, each element is a sub-list with two vectors, one for the over-expressed features, one for the under-expressed features for the current cluster
}
\description{
Screen the cluster related features via hypergeometric test p value and distribution standard derivation
}
\examples{
library(InterSIM)
sim.data <- InterSIM(n.sample=500, cluster.sample.prop = c(0.20,0.30,0.27,0.23),
delta.methyl=5, delta.expr=5, delta.protein=5,p.DMP=0.2, p.DEG=NULL,
p.DEP=NULL,sigma.methyl=NULL, sigma.expr=NULL, sigma.protein=NULL,cor.methyl.expr=NULL,
cor.expr.protein=NULL,do.plot=FALSE, sample.cluster=TRUE, feature.cluster=TRUE)
sim.methyl <- sim.data$dat.methyl
sim.expr <- sim.data$dat.expr
sim.protein <- sim.data$dat.protein
temp_data <- list(sim.methyl, sim.expr, sim.protein)
M3JF_res <- M3JF(temp_data,k=4)
feature_list <- feature_selection(temp_data[[1]],M3JF_res$cluster_res,z_score=TRUE,
upper_bound=1, lower_bound=-1)
selected_features <- feature_screen_sd(feature_list,sig_num=20)
}
