// Generated by rstantools.  Do not edit by hand.

/*
    MADPop is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    MADPop is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MADPop.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_DirichletMultinomial_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 42> locations_array__ =
  {" (found before start of program)",
  " (in 'DirichletMultinomial', line 64, column 2 to column 20)",
  " (in 'DirichletMultinomial', line 65, column 2 to column 20)",
  " (in 'DirichletMultinomial', line 78, column 2 to column 31)",
  " (in 'DirichletMultinomial', line 81, column 6 to column 69)",
  " (in 'DirichletMultinomial', line 80, column 23 to line 82, column 5)",
  " (in 'DirichletMultinomial', line 80, column 4 to line 82, column 5)",
  " (in 'DirichletMultinomial', line 79, column 16 to line 83, column 3)",
  " (in 'DirichletMultinomial', line 79, column 2 to line 83, column 3)",
  " (in 'DirichletMultinomial', line 70, column 2 to column 41)",
  " (in 'DirichletMultinomial', line 74, column 2 to column 26)",
  " (in 'DirichletMultinomial', line 56, column 2 to column 18)",
  " (in 'DirichletMultinomial', line 57, column 2 to column 18)",
  " (in 'DirichletMultinomial', line 58, column 8 to column 10)",
  " (in 'DirichletMultinomial', line 58, column 11 to column 13)",
  " (in 'DirichletMultinomial', line 58, column 2 to column 30)",
  " (in 'DirichletMultinomial', line 60, column 2 to column 30)",
  " (in 'DirichletMultinomial', line 61, column 8 to column 13)",
  " (in 'DirichletMultinomial', line 61, column 2 to column 43)",
  " (in 'DirichletMultinomial', line 64, column 10 to column 12)",
  " (in 'DirichletMultinomial', line 78, column 8 to column 13)",
  " (in 'DirichletMultinomial', line 78, column 23 to column 25)",
  " (in 'DirichletMultinomial', line 32, column 4 to column 19)",
  " (in 'DirichletMultinomial', line 33, column 4 to column 13)",
  " (in 'DirichletMultinomial', line 34, column 4 to column 14)",
  " (in 'DirichletMultinomial', line 35, column 4 to column 16)",
  " (in 'DirichletMultinomial', line 36, column 4 to column 16)",
  " (in 'DirichletMultinomial', line 38, column 4 to column 20)",
  " (in 'DirichletMultinomial', line 39, column 4 to column 17)",
  " (in 'DirichletMultinomial', line 41, column 6 to column 32)",
  " (in 'DirichletMultinomial', line 40, column 22 to line 42, column 5)",
  " (in 'DirichletMultinomial', line 40, column 4 to line 42, column 5)",
  " (in 'DirichletMultinomial', line 44, column 4 to column 14)",
  " (in 'DirichletMultinomial', line 47, column 1 to column 35)",
  " (in 'DirichletMultinomial', line 46, column 24 to line 48, column 7)",
  " (in 'DirichletMultinomial', line 46, column 6 to line 48, column 7)",
  " (in 'DirichletMultinomial', line 49, column 6 to column 37)",
  " (in 'DirichletMultinomial', line 45, column 22 to line 50, column 5)",
  " (in 'DirichletMultinomial', line 45, column 4 to line 50, column 5)",
  " (in 'DirichletMultinomial', line 51, column 4 to column 42)",
  " (in 'DirichletMultinomial', line 52, column 4 to column 15)",
  " (in 'DirichletMultinomial', line 31, column 62 to line 53, column 3)"};
template <bool propto__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>* = nullptr>
stan::promote_args_t<stan::base_type_t<T1__>>
Dirichlet_Multinomial_lpmf(const std::vector<std::vector<int>>& X,
                           const T1__& eta_arg__, std::ostream* pstream__);
template <bool propto__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>*>
stan::promote_args_t<stan::base_type_t<T1__>>
Dirichlet_Multinomial_lpmf(const std::vector<std::vector<int>>& X,
                           const T1__& eta_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T1__>>;
  int current_statement__ = 0;
  const auto& eta = stan::math::to_ref(eta_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    std::vector<int> D = std::vector<int>(2, std::numeric_limits<int>::min());
    local_scalar_t__ ans = DUMMY_VAR__;
    local_scalar_t__ seta = DUMMY_VAR__;
    local_scalar_t__ slgeta = DUMMY_VAR__;
    current_statement__ = 26;
    stan::model::assign(D, stan::math::dims(X), "assigning variable D");
    current_statement__ = 27;
    seta = stan::math::sum(eta);
    current_statement__ = 28;
    slgeta = 0.0;
    current_statement__ = 31;
    for (int jj = 1; jj <=
         stan::model::rvalue(D, "D", stan::model::index_uni(2)); ++jj) {
      current_statement__ = 29;
      slgeta = (slgeta +
        stan::math::lgamma(
          stan::model::rvalue(eta, "eta", stan::model::index_uni(jj))));
    }
    current_statement__ = 32;
    ans = 0.0;
    current_statement__ = 38;
    for (int ii = 1; ii <=
         stan::model::rvalue(D, "D", stan::model::index_uni(1)); ++ii) {
      current_statement__ = 35;
      for (int jj = 1; jj <=
           stan::model::rvalue(D, "D", stan::model::index_uni(2)); ++jj) {
        current_statement__ = 33;
        ans = (ans +
          stan::math::lgamma(
            (stan::model::rvalue(X, "X", stan::model::index_uni(ii),
               stan::model::index_uni(jj)) +
            stan::model::rvalue(eta, "eta", stan::model::index_uni(jj)))));
      }
      current_statement__ = 36;
      ans = (ans -
        stan::math::lgamma(
          (stan::math::sum(
             stan::model::rvalue(X, "X", stan::model::index_uni(ii))) + seta)));
    }
    current_statement__ = 39;
    ans = (ans + (stan::model::rvalue(D, "D", stan::model::index_uni(1)) *
      (stan::math::lgamma(seta) - slgeta)));
    current_statement__ = 40;
    return ans;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_DirichletMultinomial final : public model_base_crtp<model_DirichletMultinomial> {
private:
  int nG;
  int nL;
  std::vector<std::vector<int>> X;
  int nLrho;
  std::vector<int> iLrho;
public:
  ~model_DirichletMultinomial() {}
  model_DirichletMultinomial(stan::io::var_context& context__, unsigned int
                             random_seed__ = 0, std::ostream*
                             pstream__ = nullptr) : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_DirichletMultinomial_namespace::model_DirichletMultinomial";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 11;
      context__.validate_dims("data initialization", "nG", "int",
        std::vector<size_t>{});
      nG = std::numeric_limits<int>::min();
      current_statement__ = 11;
      nG = context__.vals_i("nG")[(1 - 1)];
      current_statement__ = 11;
      stan::math::check_greater_or_equal(function__, "nG", nG, 1);
      current_statement__ = 12;
      context__.validate_dims("data initialization", "nL", "int",
        std::vector<size_t>{});
      nL = std::numeric_limits<int>::min();
      current_statement__ = 12;
      nL = context__.vals_i("nL")[(1 - 1)];
      current_statement__ = 12;
      stan::math::check_greater_or_equal(function__, "nL", nL, 1);
      current_statement__ = 13;
      stan::math::validate_non_negative_index("X", "nL", nL);
      current_statement__ = 14;
      stan::math::validate_non_negative_index("X", "nG", nG);
      current_statement__ = 15;
      context__.validate_dims("data initialization", "X", "int",
        std::vector<size_t>{static_cast<size_t>(nL), static_cast<size_t>(nG)});
      X = std::vector<std::vector<int>>(nL,
            std::vector<int>(nG, std::numeric_limits<int>::min()));
      {
        std::vector<int> X_flat__;
        current_statement__ = 15;
        X_flat__ = context__.vals_i("X");
        current_statement__ = 15;
        pos__ = 1;
        current_statement__ = 15;
        for (int sym1__ = 1; sym1__ <= nG; ++sym1__) {
          current_statement__ = 15;
          for (int sym2__ = 1; sym2__ <= nL; ++sym2__) {
            current_statement__ = 15;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 15;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 15;
      stan::math::check_greater_or_equal(function__, "X", X, 0);
      current_statement__ = 16;
      context__.validate_dims("data initialization", "nLrho", "int",
        std::vector<size_t>{});
      nLrho = std::numeric_limits<int>::min();
      current_statement__ = 16;
      nLrho = context__.vals_i("nLrho")[(1 - 1)];
      current_statement__ = 16;
      stan::math::check_greater_or_equal(function__, "nLrho", nLrho, 0);
      current_statement__ = 16;
      stan::math::check_less_or_equal(function__, "nLrho", nLrho, nL);
      current_statement__ = 17;
      stan::math::validate_non_negative_index("iLrho", "nLrho", nLrho);
      current_statement__ = 18;
      context__.validate_dims("data initialization", "iLrho", "int",
        std::vector<size_t>{static_cast<size_t>(nLrho)});
      iLrho = std::vector<int>(nLrho, std::numeric_limits<int>::min());
      current_statement__ = 18;
      iLrho = context__.vals_i("iLrho");
      current_statement__ = 18;
      stan::math::check_greater_or_equal(function__, "iLrho", iLrho, 1);
      current_statement__ = 18;
      stan::math::check_less_or_equal(function__, "iLrho", iLrho, nL);
      current_statement__ = 19;
      stan::math::validate_positive_index("alpha", "nG", nG);
      current_statement__ = 20;
      stan::math::validate_non_negative_index("rho", "nLrho", nLrho);
      current_statement__ = 21;
      stan::math::validate_non_negative_index("rho", "nG", nG);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = (nG - 1) + 1;
  }
  inline std::string model_name() const final {
    return "model_DirichletMultinomial";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_DirichletMultinomial_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nG, DUMMY_VAR__);
      current_statement__ = 1;
      alpha = in__.template read_constrain_simplex<
                Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, nG);
      local_scalar_t__ eta = DUMMY_VAR__;
      current_statement__ = 2;
      eta = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      {
        current_statement__ = 9;
        lp_accum__.add(Dirichlet_Multinomial_lpmf<propto__>(X,
                         stan::math::multiply(eta, alpha), pstream__));
        current_statement__ = 10;
        lp_accum__.add((-2 * stan::math::log((1 + eta))));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_DirichletMultinomial_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> alpha =
        Eigen::Matrix<double,-1,1>::Constant(nG,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      alpha = in__.template read_constrain_simplex<
                Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, nG);
      double eta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      eta = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      out__.write(alpha);
      out__.write(eta);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      std::vector<Eigen::Matrix<double,-1,1>> rho =
        std::vector<Eigen::Matrix<double,-1,1>>(nLrho,
          Eigen::Matrix<double,-1,1>::Constant(nG,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 8;
      if (stan::math::logical_gt(nLrho, 0)) {
        current_statement__ = 6;
        for (int ii = 1; ii <= nLrho; ++ii) {
          current_statement__ = 4;
          stan::model::assign(rho,
            stan::math::dirichlet_rng(
              stan::math::add(
                stan::math::to_vector(
                  stan::model::rvalue(X, "X",
                    stan::model::index_uni(
                      stan::model::rvalue(iLrho, "iLrho",
                        stan::model::index_uni(ii))))),
                stan::math::multiply(eta, alpha)), base_rng__),
            "assigning variable rho", stan::model::index_uni(ii));
        }
      }
      current_statement__ = 3;
      stan::math::check_simplex(function__, "rho", rho);
      for (int sym1__ = 1; sym1__ <= nG; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nLrho; ++sym2__) {
          out__.write(rho[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nG, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(alpha,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(nG),
        "assigning variable alpha");
      out__.write_free_simplex(alpha);
      local_scalar_t__ eta = DUMMY_VAR__;
      current_statement__ = 2;
      eta = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, eta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "alpha", "double",
        std::vector<size_t>{static_cast<size_t>(nG)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "eta", "double",
        std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nG, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 1;
        alpha_flat__ = context__.vals_r("alpha");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= nG; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(alpha, alpha_flat__[(pos__ - 1)],
            "assigning variable alpha", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_simplex(alpha);
      local_scalar_t__ eta = DUMMY_VAR__;
      current_statement__ = 2;
      eta = context__.vals_r("eta")[(1 - 1)];
      out__.write_free_lb(0, eta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"alpha", "eta"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"rho"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    nG)},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(nLrho),
               static_cast<size_t>(nG)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= nG; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "eta");
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nG; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nLrho; ++sym2__) {
          param_names__.emplace_back(std::string() + "rho" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= (nG - 1); ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "eta");
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= (nG - 1); ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nLrho; ++sym2__) {
          param_names__.emplace_back(std::string() + "rho" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nG) + "},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(nLrho) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(nG) + "}},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string((nG -1)) + "},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(nLrho) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string((nG -1)) + "}},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (nG + 1);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * ((nLrho *
      nG));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (nG + 1);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * ((nLrho *
      nG));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_DirichletMultinomial_namespace::model_DirichletMultinomial;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_DirichletMultinomial_namespace::profiles__;
}
#endif
#endif
