% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_weights.R
\name{estimate_weights}
\alias{estimate_weights}
\title{Functions for the Estimation of Propensity Weights}
\arguments{
\item{ipds}{A data frame containing individual patient data from the
intervention study, with baseline characteristic variables for matching.}

\item{agds}{A data frame containing aggregate summary data from the
comparator study.}

\item{matching.list}{A character list with two elements giving the names
of variables for matching: the first is a vector of binary variables, and
the second is a vector of continuous variables. The variable names must
match the column names in \emph{ipds} and \emph{agds}. Use c() if a type is absent.}

\item{intervention.arm}{The name of the grouping column in the data frame
specified by \emph{ipds}, e.g., intervention.arm = TRT. The default is TRT.}

\item{comparator}{The name of the study column in the data frame specified
by \emph{agds}, e.g., comparator = STUDY. The default is STUDY.}

\item{comparator.study}{A character specifying the comparator study, which
must be quoted and cannot be empty (e.g., comparator.study = "Study XX-1").
This is the value of the study column in \emph{agds} set by the \emph{comparator}
parameter.}

\item{comparator.arm}{The name of the grouping column in the data frame
specified by \emph{agds}, e.g., comparator.arm = TRT. The default is TRT.}

\item{opt.method}{The optim method to be used. The default is "BFGS".}

\item{seed}{The seed for centralized variable missing value imputation
(KNN method).}

\item{...}{Refer to \link[stats:optim]{optim} for additional parameters.}
}
\value{
A data frame containing individual patient data, calculated weights,
and rescaled weights.
}
\description{
Functions for the Estimation of Propensity Weights
}
\examples{
\donttest{
cov <- list(
  c("ECOG", "SMK", "METBRAIN"),
  c("BMI", "DIAG")
)

pts <- estimate_weights(
  ipds = IPD,
  agds = AgD_bl,
  matching.list = cov,
  intervention.arm = TRT,
  comparator = STUDY,
  comparator.study = "Study XX-1",
  comparator.arm = TRT
)
}
}
