% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist_weights.R
\name{hist_weights}
\alias{hist_weights}
\title{Histograms of Weights and Rescaled Weights Distributions}
\arguments{
\item{ipds_wts}{A data frame containing individual patient data from the
intervention study, with a column containing the estimated weights
(derived using \code{\link{estimate_weights}}).}

\item{intervention.arm}{The name of the grouping column in the data frame
specified by \emph{ipds}, e.g., \code{intervention.arm = TRT}. The default is \code{TRT}.}

\item{wt.col}{The name of the estimated weights column in the data frame
specified by \emph{ipds_wts}. The default is \code{wt}.}

\item{rswt.col}{The name of the estimated rescaled weights column in the
data frame specified by \emph{ipds_wts}. The default is \code{wt_rs}.}

\item{bin}{The number of bins or bars of the histogram.}

\item{xstepby}{An integer guiding the breaks on the X-axis.}

\item{ystepby}{An integer guiding the breaks on the Y-axis.}

\item{...}{Refer to \link[ggplot2:geom_histogram]{geom_histogram} for
additional parameters.}
}
\value{
Histograms of weights and rescaled weights distributions.
}
\description{
Histograms of Weights and Rescaled Weights Distributions
}
\examples{
\donttest{
hist_weights(pts, intervention.arm = TRT, xstepby = 2, ystepby = 50)
}
}
