% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative.array-class.R
\name{rank.relative.array}
\alias{rank.relative.array}
\title{Rank relative effects obtained between specific doses}
\usage{
\method{rank}{relative.array}(x, lower_better = TRUE, ...)
}
\arguments{
\item{x}{An object on which to apply the rank method}

\item{lower_better}{Indicates whether negative responses are better (\code{TRUE}) or positive responses are better (\code{FALSE})}

\item{...}{Arguments to be passed to methods}
}
\value{
An object of \code{class("mbnma.rank")} which is a list containing a summary data
frame, a matrix of rankings for each MCMC iteration, and a matrix of probabilities
that each agent has a particular rank, for each parameter that has been ranked.
}
\description{
Ranks \code{"relative.table"} objects generated by \code{get.relative()}.
}
\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(triptans)

# Rank selected predictions from an Emax dose-response MBNMA
emax <- mbnma.run(network, fun=demax(), method="random")
rels <- get.relative(emax)
rank <- rank(rels, lower_better=TRUE)

# Print and generate summary data frame for `mbnma.rank` object
summary(rank)
print(rank)

# Plot `mbnma.rank` object
plot(rank)
}

}
