% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.functions.R
\name{tpoly}
\alias{tpoly}
\title{Polynomial time-course function}
\usage{
tpoly(
  degree = 1,
  pool.1 = "rel",
  method.1 = "common",
  pool.2 = "rel",
  method.2 = "common",
  pool.3 = "rel",
  method.3 = "common",
  pool.4 = "rel",
  method.4 = "common"
)
}
\arguments{
\item{degree}{The degree of the polynomial - e.g. \code{degree=1} for linear, \code{degree=2} for quadratic, \code{degree=3} for cubic.}

\item{pool.1}{Pooling for the 1st polynomial coefficient. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.1}{Method for synthesis of the 1st polynomial coefficient.Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}

\item{pool.2}{Pooling for the 2nd polynomial coefficient. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.2}{Method for synthesis of the 2nd polynomial coefficient. Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}

\item{pool.3}{Pooling for the 3rd polynomial coefficient. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.3}{Method for synthesis of the 3rd polynomial coefficient. Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}

\item{pool.4}{Pooling for the 4th polynomial coefficient. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.4}{Method for synthesis of the 4th polynomial coefficient. Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}
}
\value{
An object of \code{class("timefun")}
}
\description{
Polynomial time-course function
}
\details{
\itemize{
\item \eqn{\beta_1} represents the 1st coefficient.
\item \eqn{\beta_2} represents the 2nd coefficient.
\item \eqn{\beta_3} represents the 3rd coefficient.
\item \eqn{\beta_4} represents the 4th coefficient.
}

Linear model:
\deqn{\beta_1{x}}

Quadratic model:
\deqn{\beta_1{x} + \beta_2{x^2}}

Cubic model:
\deqn{\beta_1{x} + \beta_2{x^2} + \beta_3{x^3}}

Quartic model:
\deqn{\beta_1{x} + \beta_2{x^2} + \beta_3{x^3} + \beta_4{x^4}}
}
\section{Time-course parameters}{

Time-course parameters in the model must be specified using a \code{pool} and a \code{method} prefix.

\code{pool} is used to define the approach used for pooling of a given time-course parameter and
can take any of:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Indicates that \emph{relative} effects should be pooled for this time-course parameter. Relative effects preserve randomisation within included studies, are likely to vary less between studies (only due to effect modification), and allow for testing of consistency between direct and indirect evidence. Pooling follows the general approach for Network Meta-Analysis proposed by \insertCite{lu2004;textual}{MBNMAtime}. \cr
   \code{"abs"} \tab Indicates that study arms should be pooled across the whole network for this time-course parameter  \emph{independently of assigned treatment} to estimate an \emph{absolute} effect. This implies estimating a single value across the network for this time-course parameter, and may therefore be making strong assumptions of similarity. \cr
}


\code{method} is used to define the model used for meta-analysis for a given time-course parameter
and can take any of the following values:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"common"} \tab Implies that all studies estimate the same true effect (often called a "fixed effect" meta-analysis) \cr
   \code{"random"} \tab Implies that all studies estimate a separate true effect, but that each of these true effects vary randomly around a true mean effect. This approach allows for modelling of between-study heterogeneity. \cr
   \code{numeric()} \tab Assigned a numeric value, indicating that this time-course parameter should not be estimated from the data but should be assigned the numeric value determined by the user. This can be useful for fixing specific time-course parameters (e.g. Hill parameters in Emax functions, power parameters in fractional polynomials) to a single value. \cr
}


When relative effects are modelled on more than one time-course parameter,
correlation between them is automatically estimated using a vague inverse-Wishart prior.
}

\examples{
# Linear model with random effects
tpoly(pool.1="rel", method.1="random")

# Quadratic model with a single absolute parameter estimated for the 2nd coefficient
tpoly(pool.1="rel", method.1="common", pool.2="abs", method.2="random")

}
\references{
\insertAllCited
}
