% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esti_polyserial.R
\name{esti_polyserial}
\alias{esti_polyserial}
\title{Polyserial Correlation}
\usage{
esti_polyserial(X, maxn = 100, e = 1e-08)
}
\arguments{
\item{X}{a matrix(2*N) or dataframe contains two polyserial variable(Continuous variable first).}

\item{maxn}{the maximum iterations times.}

\item{e}{the maximum tolerance of convergence.}
}
\value{
\item{rho}{estimated value of polyserial correlation coefficient.}

\item{std}{standard deviation of rho.}

\item{iter}{times of iteration convergence.}

\item{Ex,Ey}{the support point of regression model.}
}
\description{
Estimate the polyserial correlation coefficient.
}
\examples{
X = gen_polyseries(1000,0.5,-1:1)
result = esti_polyserial(X)
result
}
\references{
Zhang, P., Liu, B., & Pan, J. (2024). Iteratively Reweighted Least Squares Method for Estimating Polyserial and Polychoric Correlation Coefficients. Journal of Computational and Graphical Statistics, 33(1), 316–328. https://doi.org/10.1080/10618600.2023.2257251
}
\seealso{
\link{esti_polychoric}
}
