% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCPbarplot.R
\name{MCPbarplot}
\alias{MCPbarplot}
\title{Plotting the result of the multiple comparison procedures}
\usage{
MCPbarplot(
  x,
  MCP = "all",
  col = grDevices::heat.colors(10),
  horiz = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of the \code{MCPtest} function}

\item{MCP}{Allows choosing the multiple comparison test.
The \emph{defaut} is "all". This option will perform all tests
available in the \code{MCPtest} object.}

\item{col}{A specification for the plotting color.
The \emph{defaut} is \code{heat.colors(10)}.}

\item{horiz}{a logical value. If \code{FALSE}, the bars are drawn
vertically with the first bar to the left. If \code{TRUE},
the bars are drawn horizontally with the first at the bottom.}

\item{...}{Parameters of the \code{\link{barplot}} function}
}
\value{
\code{MCPbarplot} return the bar plot of the tests chosen
    ("MGM", "MGR", "SNKM", "TM", "SK")
    to evaluate the treatment means.
}
\description{
\code{MCPbarplot} creates a bar plot with vertical or horizontal bars
    to compare the mean treatments by the tests:
    means grouping based on midrange test, means grouping based on range test,
    Student-Newman-Keuls and Tukey based on midrange tests, Scott-Knott's test
}
\details{
The \code{MCP} argument allows choosing several tests
    of multiple comparisons from the
    \code{MCPtest} object. For plots in papers, use
    \code{col = gray.colors(10)}. For details, see
    \code{\link[grDevices]{colors}} function.
}
\examples{
# Simulated data (completely randomized design)

rv <- c(100.08, 105.66, 97.64, 100.11, 102.60, 121.29, 100.80,
        99.11, 104.43, 122.18, 119.49, 124.37, 123.19, 134.16,
        125.67, 128.88, 148.07, 134.27, 151.53, 127.31)

# Treatments
treat <- factor(rep(LETTERS[1:5], each = 4))

# Anova
res     <- aov(rv~treat)

# Loading the MCPtests package
library(MCPtests)

# Choosing tests
results <- MCPtest(y = res, trt = "treat", alpha = 0.05,
                   main = "Multiple Comparison Procedures",
                   MCP = c("MGM", "TM"))

MCPbarplot(results, MCP = "all") # It will be shown two
                             # graphs. First, for the
                             # results of \code{'MGM'}
                             # and the second for the
                             # results of \code{'TM'}.

MCPbarplot(results, MCP = "MGM") # It will be shown
                                 # only the graph
                                 # for the result of
                                 # \code{'MGM'}

# Plot for papers
MCPbarplot(results, MCP = "all", col = gray.colors(10))
}
