% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot Heatmap}
\usage{
plot_heatmap(data, cell_width = 1, cell_height = 1, ...)
}
\arguments{
\item{data}{A matrix or data frame to be visualized as a heatmap.
The row names and column names of the data will be used for labeling
the heatmap axes.}

\item{cell_width}{Numeric value indicating the width of each cell
in the heatmap. Default is 1.}

\item{cell_height}{Numeric value indicating the height of each cell
in the heatmap. Default is 1.}

\item{...}{Additional arguments to be passed to ggplot2 functions.}
}
\value{
A ggplot2 object representing the heatmap.
}
\description{
Creates a heatmap plot from a matrix or data frame.
}
\examples{
# Example data
data <- matrix(rnorm(100), nrow = 10, ncol = 10)
rownames(data) <- paste0("Row", 1:10)
colnames(data) <- paste0("Col", 1:10)

# Plot heatmap
plot <- plot_heatmap(data)
print(plot)
}
