% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmeipw.R
\name{lmeipw}
\alias{lmeipw}
\title{Fits a marginal model using IPW}
\usage{
lmeipw(
  data,
  M = 5,
  id,
  analysis.model,
  wgt.model,
  qpoints = 4,
  nu,
  sigmaR,
  dist,
  link,
  conv = 1e-04,
  maxiter,
  maxpiinv = -1,
  se = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{data}{longitudinal data with each subject specified discretely}

\item{M}{number of imputation to be used in the estimation of augmentation term}

\item{id}{cloumn names which shows identification number for each subject}

\item{analysis.model}{A formula to be used as analysis model}

\item{wgt.model}{Formula for weight model, which consider subject specific random intercept}

\item{qpoints}{Number of quadrature points to be used while evaluating the numerical integration}

\item{nu}{working model parameter}

\item{sigmaR}{working model parameter}

\item{dist}{distribution for imputation model. Currently available options are Gaussian, Binomial}

\item{link}{Link function for the mean}

\item{conv}{convergence tolerance}

\item{maxiter}{maximum number of iteration}

\item{maxpiinv}{maximum value pi can take}

\item{se}{Logical for Asymptotic SE for regression coefficient of the regression model.}

\item{verbose}{logical argument}
}
\value{
A list of objects containing the following objects
\describe{
  \item{Call}{details about arguments passed in the function}
  \item{nr.conv}{logical for checking convergence in Newton Raphson algorithm}
  \item{nr.iter}{number of iteration required}
  \item{nr.diff}{absolute difference for roots of Newton Raphson algorithm}
  \item{beta}{estimated regression coefficient for the analysis model}
  \item{var.beta}{Asymptotic SE for beta}
}
}
\description{
provides inverse probability weighted estimates of parameters for semiparametric marginal model
of response variable of interest. The weights are computed using a generalized linear mixed effect model.
}
\details{
lmeipw

It uses the simple inverse probability weighted method to reduce the bias
due to missing values in response model for longitudinal data.The response variable \eqn{\mathbf{Y}} is related to the covariates as \eqn{g(\mu)=\mathbf{X}\beta}, where \code{g} is the link function for the glm. The estimating equation is
\deqn{\sum_{i=1}^{n}\sum_{j=t_1}^{t_k}\int_{a_i}\frac{\delta_{ij}}{\hat\pi_{ij}(a_i)}S(Y_{ij},\mathbf{X}_{ij})da_i=0}
where \eqn{\delta_{ij}=1} if there is missing no value in response and 0 otherwise.
\eqn{\mathbf{X}} is fully observed all subjects and for the missing data probability \deqn{Logit(P(\delta_{ij}=1|\mathbf{V}_{ij}\nu+a_i))\;;a_i\sim N(0,\sigma_R)}; where \eqn{\mathbf{V}_{ij}=(\mathbf{X}_{ij},A_{ij})}
}
\examples{
 \dontrun{
##
library(JMbayes2)
library(lme4)
library(insight)
library(numDeriv)
library(stats)
lmer(log(alkaline)~drug+age+year+(1|id),data=na.omit(pbc2))
data1<-pbc2
data1$alkaline<-log(data1$alkaline)
names(pbc2)
apply(pbc2,2,function(x){sum(is.na(x))})
r.ij<-ifelse(is.na(data1$alkaline)==T,0,1)
data1<-cbind.data.frame(data1,r.ij)
data1$drug<-factor(data1$drug,levels=c("placebo","D-penicil"),labels = c(0,1))
data1$sex<-factor(data1$sex,levels=c('male','female'),labels=c(1,0))
data1$drug<-as.numeric(as.character(data1$drug))
data1$sex<-as.numeric(as.character(data1$sex))
r.ij~year+age+sex+drug+serBilir+(1|id)
model.r<-glmer(r.ij~year+age+sex+drug+serBilir+(1|id),family=binomial(link='logit'),data=data1)
nu<-model.r@beta
sigmaR<-get_variance(model.r)$var.random
m11<-lmeipw(data=data1,id='id',
            analysis.model = alkaline~year,
            wgt.model=~year+age+sex+drug+serBilir+(1|id),
            nu=nu,sigmaR=sigmaR,dist='gaussian',link='identity',qpoints=4,
            maxiter = 200)
m11
##
}
}
\references{
Wang, C. Y., Shen-Ming Lee, and Edward C. Chao. "Numerical equivalence of imputing scores and weighted estimators in regression analysis with missing covariates." Biostatistics 8.2 (2007): 468-473.

Seaman, Shaun R., and Stijn Vansteelandt. "Introduction to double robust methods for incomplete data." Statistical science: a review journal of the Institute of Mathematical Statistics 33.2 (2018): 184.

Vansteelandt, Stijn, James Carpenter, and Michael G. Kenward. "Analysis of incomplete data using inverse probability weighting and doubly robust estimators." Methodology: European Journal of Research Methods for the Behavioral and Social Sciences 6.1 (2010): 37.
}
\seealso{
\link[MIIPW]{SIPW},\link[MIIPW]{miSIPW},\link[MIIPW]{miAIPW}
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra Kumar Vishwakarma
}
