% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcre_smooth.R
\name{smooth.construct.unc_pcre.smooth.spec}
\alias{smooth.construct.unc_pcre.smooth.spec}
\title{mgcv-style constructor for PC-basis functional random effects (no constraint)}
\usage{
\method{smooth.construct}{unc_pcre.smooth.spec}(object, data, knots, ...)
}
\arguments{
\item{object}{a smooth specification object, see
\code{\link[mgcv]{smooth.construct}}}

\item{data}{see \code{\link[mgcv]{smooth.construct}}.}

\item{knots}{see \code{\link[mgcv]{smooth.construct}}.}

\item{...}{see \code{\link[bamlss]{smooth.construct}}.}
}
\value{
An object of class \code{"random.effect"}. See
\code{\link[mgcv]{smooth.construct}}
 for the elements that this object will contain.
}
\description{
Sets up design matrix for functional random effects based on the PC scores
of the covariance operator of the random effect process. Note that there is
no constraint on the smoother.
See \code{\link[mgcv]{smooth.construct.re.smooth.spec}} for more details on
\code{mgcv}-style smoother specification
and \code{\link[refund]{smooth.construct.pcre.smooth.spec}} for the
corresponding \code{refund} implementation.
}
\details{
This is an internal function as the corresponding smooth object and its
predict method is primarily used within the bamlss call.
}
\examples{
data(pbc_subset)
mfpca <- preproc_MFPCA(pbc_subset, uni_mean = paste0(
  "logy ~ 1 + sex + drug + s(obstime, k = 5, bs = 'ps') + ",
  "s(age, k = 5, bs = 'ps')"),
  pve_uni = 0.99, nbasis = 5, weights = TRUE, save_uniFPCA = TRUE)
pbc_subset <- attach_wfpc(mfpca, pbc_subset, n = 2)
mfpca_list <- list(
  list(functions = funData::extractObs(mfpca$functions, 1),
       values = mfpca$values[1]),
  list(functions = funData::extractObs(mfpca$functions, 2),
       values = mfpca$values[2]))
sm <- smoothCon(s(id, fpc.1, bs = "unc_pcre",
      xt = list("mfpc" = mfpca_list[[1]], scale = "FALSE")), pbc_subset)
}
\author{
Alexander Volkmann; adapted from 'pcre' constructor by F. Scheipl
 (adapted from 're' constructor by S.N. Wood).
}
