% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moibasic.R
\name{moi_duplicatefinder}
\alias{moi_duplicatefinder}
\title{Finds forbidden sample ID repetitions}
\usage{
moi_duplicatefinder(total, sam_mark, nummtd, rw_col)
}
\arguments{
\item{total}{string vector; vector of sample IDs.}

\item{sam_mark}{string; a string which is either "Sample
ID" or "Marker".}

\item{nummtd}{numeric; number of metadata columns plus 2.}

\item{rw_col}{string vector; variable used to switch
between row and column in case of transposed data.
Namely, \code{c("rows ", "row ", "column ", "columns
")}.}
}
\value{
a warning which informs the user of forbidden
  repetition of sample ID's or marker labels.
}
\description{
Sample IDs need to be uniquely assigned to
  samples. This function checks if a sample ID is
  assigned to two or more different samples. Similarly,
  the marker labels need to be uniquely defined. This
  function is also used to check forbidden marker label
  repetitions.
}
\seealso{
For further details see: \code{moimport}
  \code{\link{moi_labels}}.
}
\keyword{internal}
