% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarshallOlkin_utils.R
\name{BiCopPar2Tau.MO}
\alias{BiCopPar2Tau.MO}
\alias{BiCopTau2Par.MO}
\title{Convert between parameter and Kendall's tau for Marshall-Olkin copulas}
\usage{
BiCopPar2Tau.MO(par)

BiCopTau2Par.MO(tau)
}
\arguments{
\item{par}{the parameter of the Marshall-Olkin copula}

\item{tau}{the Kendall's tau of the Marshall-Olkin copula}
}
\value{
Either the Kendall's tau or the parameter of the Marshall-Olkin copula.
}
\description{
Convert between parameter and Kendall's tau for Marshall-Olkin copulas
}
\examples{
BiCopPar2Tau.MO(par = 0.5)
BiCopTau2Par.MO(tau = 1/3)

}
\references{
Nelsen, R. B. (2007). An introduction to copulas. Springer Science & Business Media.
(Example 5.5)
}
