% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lapprox.R
\name{Lapprox}
\alias{Lapprox}
\title{Compute a rank \code{k} approximation of a graph Laplacian}
\usage{
Lapprox(LapList, k, laplacian = c("shift", "Ng", "sym", "rw"), plots = TRUE)
}
\arguments{
\item{LapList}{A list of Laplacian matrices}

\item{k}{A vector indicating how many eigenvectors to take from each Laplacian, i.e., the number of clusters in each view}

\item{laplacian}{One of \code{"shift"}, \code{"Ng"}, \code{"rw"} or \code{"sym"}. Should be the same type used to calculate your Laplacians}

\item{plots}{Whether or not to plot the eigenvalues from the rank approximated Laplacians}
}
\value{
An n\eqn{\times}n matrix
}
\description{
This function calculates the rank-\code{k} approximation of a graph Laplacian (or any symmetric matrix). This function performs \link[base]{eigen} decomposition on the given matrix \code{L} and reconstructs it using only the LAST \code{k} eigenvectors and eigenvalues.
}
\examples{

## Generating data with 2 and 3 distinct clusters
## Note that 'clustStruct' returns a list
n=120; k <- c(2,3)
set.seed(23)
dd <- clustStruct(n=n, p=30, k=k, noiseDat='random')

## Laplacians
L_list <- lapply(dd, kernelLaplacian, kernel="Spectrum",
 laplacian='shift', plots=FALSE, verbose=FALSE)

trueGroups(n,k)

La <- Lapprox(L_list, k=k, plots=FALSE)

kmeans(La$vectors[,1:4], centers=4)
}
