% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.est.R
\name{norm_est}
\alias{norm_est}
\title{Method of Moments Estimation of Normal distribution}
\usage{
norm_est(
  data,
  unknown = c("mean", "sd", "both"),
  mean = NULL,
  sd = NULL,
  plot = TRUE,
  curvecol = "red",
  ...
)
}
\arguments{
\item{data}{A numeric vector.}

\item{unknown}{A character string specifying which parameter is (are) unknown to the user.}

\item{mean, sd}{mean and standard deviation of the distribution of the normal distribution, sd must be strictly positive.}

\item{plot}{logical which controls whether the histogram of the data along with the density curve of the theoretical normal distribution with the estimated parameters.}

\item{curvecol}{color of the theoretical density curve}

\item{...}{additional plotting parameters}
}
\value{
the estimated parameters by the method of moments of the data assuming the underlying distribution is normal distribution
}
\description{
function to get the method of moment estimate(s) of normal distribution
}
\examples{
norm_est(rnorm(1000),unknown="mean",sd=1)#mean unknown, but sd known
norm_est(rnorm(1000),unknown="sd",mean=0)#sd unknown, but mean known
norm_est(rnorm(1000),unknown="both")#both will be estimated
}
