% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds.R
\name{odds_ratio}
\alias{odds_ratio}
\alias{odds}
\title{Odds Ratio from 2x2 Table}
\usage{
odds_ratio(n11, n12, n21, n22, a = 0.05)

odds(n11, n12, n21, n22, a = 0.05)
}
\arguments{
\item{n11}{sample size for level 1.1}

\item{n12}{sample size for level 1.2}

\item{n21}{sample size for level 2.1}

\item{n22}{sample size for level 2.2}

\item{a}{significance level}
}
\value{
\describe{
  \item{odds}{odds ratio statistic (legacy name; see also `odds_value`)}
  \item{olow}{lower-level confidence interval of odds ratio
(legacy name; see also `odds_lower_limit`)}
  \item{ohigh}{upper-level confidence interval of odds ratio
(legacy name; see also `odds_upper_limit`)}
  \item{se}{standard error (legacy name; see also `standard_error`)}
  \item{odds_value}{odds ratio statistic (snake_case alias of `odds`)}
  \item{odds_lower_limit}{lower-level confidence interval of odds
ratio (alias of `olow`)}
  \item{odds_upper_limit}{upper-level confidence interval of odds
ratio (alias of `ohigh`)}
  \item{standard_error}{standard error (alias of `se`)}
}
}
\description{
This function displays odds ratios and their normal confidence intervals.
This statistic is calculated as (level 1.1/level 1.2) /
(level 2.1/level 2.2), which can be considered the odds of
level 1.1 given level1 overall versus level2.1 given level2 overall.
}
\details{
**Note on function and output names:** This effect size is now implemented
with the snake_case function name `odds_ratio()` to follow modern R style
guidelines. The original name `odds()` is still available as a wrapper for
backward compatibility, and both functions return the same list. The returned
object includes both the original element names (e.g., `odds`, `olow`,
`ohigh`, `se`) and newer snake_case aliases (e.g., `odds_value`,
`odds_lower_limit`, `odds_upper_limit`, `standard_error`). New code should
prefer `odds_ratio()` and the snake_case output names, but existing code
using the older names will continue to work.
}
\examples{

# A health psychologist was interested in the rates of anxiety in
# first generation and regular college students. They polled campus
# and found the following data:

  # |              | First Generation | Regular |
  # |--------------|------------------|---------|
  # | Low Anxiety  | 10               | 50      |
  # | High Anxiety | 20               | 15      |

# What are the odds for the first generation students to have anxiety?

odds_ratio(n11 = 10, n12 = 50, n21 = 20, n22 = 15, a = .05)

# Backwards-compatible wrapper (deprecated name)
odds(n11 = 10, n12 = 50, n21 = 20, n22 = 15, a = .05)
}
\keyword{effect}
\keyword{odds}
\keyword{ratios}
\keyword{size}
