% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{bracket}
\alias{bracket}
\title{bracket bounds a value on the x-axis and y-axis}
\usage{
bracket(x, yaxis, xaxis)
}
\arguments{
\item{x}{the target predicted value of interest}

\item{yaxis}{the predicted values reflecting the xaxis values}

\item{xaxis}{the series of values used to generate the predicted 
values}
}
\value{
a vector of 5 values, left, right, bottom, top and target
}
\description{
bracket scans through a series of predicted values for
    the location of a target value of the y-axis and returns the two
    y values that bracket the target, perhaps finding the values 
    closest to 0.5 in a vector between 0 and 1. It also returns the
    x-axis values that gave rise to the two values bracketing the 
    target, and finally returns the target. For example, imagine 
    generating the proportion mature for a given length of fish using 
    an equation for which there was no analytical solution to what 
    the value of the L50 or the inter-quartile distance was. Bracket
    can find the two lengths that generate proportions just below 0.5
    and just above. It does not matter if, by chance, the target is
    one of those y-axis values.
}
\examples{
 L = seq(60,160,1)
 p=c(a=0.075,b=0.075,c=1.0,alpha=100)
 asym <- srug(p=p,sizeage=L) # Schnute and Richards unified growth curve
 L25 <- linter(bracket(0.25,asym,L)) 
 L50 <- linter(bracket(0.5,asym,L)) 
 L75 <- linter(bracket(0.75,asym,L)) 
 ans <- c(L25,L50,L75,L50-L25,L75-L50)
 {cat("   L25    L50      L75   L50-L25 L75-L50 \n")
 cat(round(ans,4),"\n")} 
}
\seealso{
linter
}
