% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.r
\name{getMSY}
\alias{getMSY}
\title{getMSY calculates the MSY for the Polacheck et al 1993 equation}
\usage{
getMSY(pars, p = 1)
}
\arguments{
\item{pars}{the model parameters r, K, Binit, sigma; p is kept separate}

\item{p}{asymmetry parameter for the Polacheck et al 1993 equation,
default=1.0 = Schaefer}
}
\value{
the MSY
}
\description{
getMSY calculates the MSY for the Polacheck et al 1993 
    generalized surplus production equation. This simplifies to rK/4 
    when p = 1.0. But this is a general equation that covers off for 
    all positive values of p.
}
\examples{
param <- c(r=1.1,K=1000.0,Binit=800.0,sigma=0.075)
getMSY(param,p=1.0)     #  275       Schaefer equivalent
getMSY(param,p=1e-08)   #  404.6674  Fox equivalent
}
\references{
Polacheck, T., Hilborn, R., and A.E. Punt (1993) Fitting 
    surplus production models: Comparing methods and measuring uncertainty. 
    \emph{Canadian Journal of Fisheries and Aquatic Sciences}, 
    50: 2597-2607.
}
