% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfuns.R
\name{inthist}
\alias{inthist}
\title{inthist a replacement for the hist function for use with integers}
\usage{
inthist(
  x,
  col = 1,
  border = 1,
  width = 1,
  xlabel = "",
  ylabel = "",
  main = "",
  lwd = 1,
  xmin = NA,
  xmax = NA,
  ymax = NA,
  plotout = TRUE,
  prop = FALSE,
  inc = 1,
  xaxis = TRUE
)
}
\arguments{
\item{x}{the vector of integers to be counted and plotted OR a matrix 
of values in column 1 and counts in column 2}

\item{col}{the colour of the fill; defaults to black = 1, set this to 0
for an empty bar, but then give a value for border}

\item{border}{the colour of the outline of each bar defaults to 1}

\item{width}{denotes the width of each bar; defaults to 1, should be >0
and usually <= 1. A warning will be issued outside this range. If
< 0 then it will be reset to 1.0}

\item{xlabel}{the label for the x axis; defaults to ""}

\item{ylabel}{the label for the y axis; defaults to ""}

\item{main}{the title for the individual plot; defaults to ""}

\item{lwd}{the line width of the border; defaults to 1}

\item{xmin}{sets the lower bound for x-axis; used to match plots}

\item{xmax}{sets the upper bound for x axis; used with multiple plots}

\item{ymax}{enables external control of the maximum y value; mainly of
use when plotting multiple plots together.}

\item{plotout}{plot the histogram or not? Defaults to TRUE}

\item{prop}{plot the proportions rather than the counts}

\item{inc}{sets the xaxis increment; used to customize the axis;
defaults to 1.}

\item{xaxis}{set to FALSE to define the xaxis outside of inthist;
defaults to TRUE}
}
\value{
a matrix of values and counts is returned invisibly
}
\description{
inthist is a replacement for the 'hist' function for use with
   integers because the ordinary function fails to count them correctly. It
   treats integers (counts) as if they were real numbers. The function is 
   designed for integers and if it is given real numbers it will issue a 
   warning and then round all values before plotting. It can accept a vector 
   of integers to be counts, or a matrix of values and associated counts.
}
\examples{
 oldpar <- par(no.readonly=TRUE)
 x <- trunc(runif(1000)*10) + 1
 #plotprep(width=6,height=4)
 inthist(x,col="grey",border=3,width=0.75,xlabel="Random Uniform",
         ylabel="Frequency")
 abline(h=100)
 par(oldpar)
}
