% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppact.R
\docType{data}
\name{ppact}
\alias{ppact}
\title{Example Dataset: PPACT}
\format{
A data frame with primary outcome, cluster-level, individual level covariates:
\describe{
  \item{SID}{Study ID}
  \item{CLUST}{Cluster}
  \item{INTERVENTION}{Study arm}
  \item{AGE}{Patient age at randomization}
  \item{FEMALE}{Participant gender}
  \item{comorbid}{Diagnosis of 2 or more of the chronic medical conditions in 6 month prior to randomization}
  \item{Dep_OR_Anx}{Anxiety and/or depression diagnosis in 6 months prior to randomization}
  \item{pain_count}{Number of different pain types from which participants have diagnoses in 12 months prior to randomization}
  \item{BL_benzo_flag}{Benzodiazepine dispensed in 6 months prior to randomization}
  \item{BL_avg_daily}{Average morphine miligram equivalents dose per day in 6 month prior to randomization}
  \item{PEGS_bl}{PEGS score at baseline}
  \item{satisfied_primary}{Satisfaction with primary care services in prior 3 months}
  \item{PEGS}{PEGS score}
  \item{n}{cluster size}
}
}
\source{
ClinicalTrials.gov: NCT02113592, The manuscript of the study's main outcomes is published in the Annals of Internal Medicine (https://doi.org/10.7326/M21-1436).
}
\usage{
ppact
}
\description{
The Pain Program of Active Coping and Training(PPACT) is a large-scale, mixed methods, cluster-randomized trial (CRT) to compare the effectiveness of an integrated, interdisciplinary
program versus usual care in treating patients with chronic pain on long-term opioid treatment (CP-LOT).
The primary outcome is the impact of pain (assessed using the PEGS)
}
\keyword{datasets}
