#' @title College data
#'
#' @description
#' This dataset provides detailed information on 777 U.S. colleges and
#' universities from 1995, covering aspects of admissions, academics, finances,
#' and student demographics.
#'
#' @format A data frame with 777 rows and 16 columns:
#' \describe{
#'   \item{Name}{College name (character)}
#'   \item{Region}{US region (character)}
#'   \item{Accept}{Acceptance (integer)}
#'   \item{Enroll}{Enrollment (integer)}
#'   \item{Top10perc}{Percent of students that were top 10 in highschool class (integer)}
#'   \item{Top25perc}{Percent of students that were top 25 in highschool class (integer)}
#'   \item{F.Undergrad}{Full time undergrad (integer)}
#'   \item{P.Undergrad}{Part time undergrad (integer)}
#'   \item{Outstate}{Number of Out of state students (integer)}
#'   \item{Room.Board}{Annual room and board price (integer)}
#'   \item{PhD}{Percentage of Faculty with a PhD (integer)}
#'   \item{Terminal}{Percentage of Faculty with a terminal degree (integer)}
#'   \item{S.F.Ratio}{Student Faculty ratio (numeric)}
#'   \item{perc.alumni}{Percent of alumni who donate to the college (integer)}
#'   \item{Expend}{Instructional expenditure per student (integer)}
#'   \item{Grad.Rate}{Graduation Rate (integer)}
#' }
#'
#' @source This dataset was taken from the \href{https://lib.stat.cmu.edu/}{StatLib}
#' library which is maintained at Carnegie Mellon University.
#' Adapted from the College data set in the ISLR library with alterations made for educational purposes.
"college_data"
