% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svmTrain.R
\name{svmTrain}
\alias{svmTrain}
\title{svmTrain}
\usage{
svmTrain(
  dtInput,
  impute = TRUE,
  p = 0.3,
  parameterTuning = TRUE,
  cost = seq(from = 2, to = 10, by = 2),
  gamma = seq(from = 0.01, to = 0.1, by = 0.02),
  kernel = "radial",
  ncross = 10,
  pr.plot = TRUE,
  roc.plot = TRUE
)
}
\arguments{
\item{dtInput}{Data frame containing instances with class labels}

\item{impute}{Logical value, indicating whether to impute missing values}

\item{p}{The percentage of data that goes to training; defaults to 0.3}

\item{parameterTuning}{Logical value; indicating whether to
tune SVM hyper parameters}

\item{cost}{Cost of constraints violation}

\item{gamma}{Parameter needed for all kernels except linear}

\item{kernel}{Kernel type: 'linear', 'polynomial', 'sigmoid', or 'radial';
defaults to 'radial'}

\item{ncross}{K-fold cross validation on the training data is performed to assess the quality of the model;
defaults to 10}

\item{pr.plot}{Logical value, indicating whether to plot precision-recall (PR) curve}

\item{roc.plot}{Logical value, indicating whether to plot ROC curve}
}
\value{
Data frame containing a classification results for all instances in the data set,
where positive confidence score corresponds to  the level of support for the pair of proteins to be true positive,
whereas negative score corresponds to the level of support for the pair of proteins to be true negative.
}
\description{
The labeled feature matrix can be used as input for
Support Vector Machines (SVM) classifier. The classifier then assigns each
bait-prey pair a confidence score, indicating the level of support for
that pair of proteins to interact. Hyperparameter optimization can also be
performed to select a set of parameters that maximizes the model's performance.
This function also computes the areas under the precision-recall (PR) and
ROC curve to evaluate the performance of the classifier.
}
\examples{
data(testdfClassifier)
predidcted_SVM <-
svmTrain(testdfClassifier,impute = FALSE,p = 0.3,parameterTuning = FALSE,
cost = seq(from = 2, to = 10, by = 2),
gamma = seq(from = 0.01, to = 0.10, by = 0.02),
kernel = "radial",ncross = 10,
pr.plot = FALSE, roc.plot = TRUE)
head(predidcted_SVM)
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
