% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPCCtest.R
\name{PPCCtest}
\alias{PPCCtest}
\title{Probability Plot Correlation Coefficient(PPCC) Test for Multivariate Normality Test}
\usage{
PPCCtest(data,
         level = 0.05)
}
\arguments{
\item{data}{A numeric matrix or data frame.}

\item{level}{At the \code{0.01} or \code{0.05} significance level, the critical value. (default = \code{0.05})}
}
\value{
\item{data.cnt}{Observation \code{n} data count.}
   \item{PPCC.value}{Correlation coefficient value.}
   \item{critical.value}{Critical value proposed by Filliben (1975), corresponding to \code{data.cnt} and \code{PPCC.value}.}
   \item{test.res}{Final result of multivariate normality.}
   \item{QQPlot}{Shows Chi-Square Q-Q plot.}
}
\description{
The correlation coefficient of the quantiles and mahalanobis square are tested by using the critical value table by Filliben (1975) for the multivariate normality test.
}
\examples{
data(wine)
class1.wine <- subset(wine, class == 1)[, -1]
PPCCtest(class1.wine, level = 0.05)

}
\references{
Filliben, J. J. (1975), The Probability Plot Correlation Coefficient Test for Normality, \emph{Technometrics} 17, 111-117.
}
\keyword{MVN}
