% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPCCtest.R
\name{SPCCtest}
\alias{SPCCtest}
\title{Srivastava Plot Correlation Coefficient(SPCC) Test for Multivariate Normality Test}
\usage{
SPCCtest(data,
         k = 0,
         level = 0.05)
}
\arguments{
\item{data}{A numeric matrix or data frame.}

\item{k}{The number of principal components can be manually selected. If 0 is entered, it automatically finds k components such that the explained variance ratio is at least 70\%. (default = \code{0})}

\item{level}{At the \code{0.01} or \code{0.05} significance level, the critical value. (default = \code{0.05})}
}
\value{
\item{Srivastava.QQplot}{Shows a chi-Square Q-Q plot for each PCs using ggplot2.}
   \item{data.cnt}{Observation \code{n} data count.}
   \item{explain.ratio}{Displays all explained variance ratios.}
   \item{critical.value}{Critical value proposed by Filliben (1975), corresponding to \code{data.cnt} and \code{PPCC.value}.}
   \item{result}{Final result of multivariate normality.}
}
\description{
Using principal component analysis, the number of eigenvalues is selected such that the ratio of eigenvalues exceeds 70\%. The principal component score vectors corresponding to these selected eigenvalues are used, and testing is conducted using the threshold defined by Filliben (1975). Users have the option to select the number of eigenvalues for the analysis based on their requirements.
}
\examples{
data(wine)
class1.wine <- subset(wine, class == 1)[, -1]
SPCCtest(class1.wine, k = 5, level = 0.05)

}
\references{
Srivastava, M. S. (1984), A measure of skewness and kurtosis and a graphical method for assessing multivariate normality. Statistics & Probability Letters, 2(5), 263-267.

Filliben, J. J. (1975), The Probability Plot Correlation Coefficient Test for Normality, \emph{Technometrics} 17, 111-117.
}
\keyword{MVN}
