% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier.R
\name{outlier}
\alias{outlier}
\title{Outliers Detection}
\usage{
outlier(data,
        lim = 0,
        level = 0.05,
        option = "all")
}
\arguments{
\item{data}{A numeric matrix or data frame.}

\item{lim}{The number of outliers detected can be limited. If 0 is entered, detection is possible up to half of the data. (default = \code{0})}

\item{level}{The significance level of the skewness and kurtosis statistics of the "\code{madiatest}" function. (default = \code{0.05})}

\item{option}{\code{"skew"} refers to skewness, \code{"kurt"} refers to kurtosis, \code{"all"} refers to skewness and kurtosis. Outliers are detected until the corresponding option in the \code{mardiatest} is “Accept”. (default = \code{"all"})}
}
\value{
\item{modified.data}{The modified data without outliers.}
   \item{modified.mvn}{The modified Mardia test result without outliers.}
   \item{outlier.num}{The position of outliers.}
   \item{outlier.cnt}{Total number of outliers.}
}
\description{
Using the mardia test, outliers are detected based on skewness and kurtosis. However, outliers don't detect more than half of the total observation data.(Can be modified with the \code{lim} option.)
}
\examples{
data(wine)
class2.wine <- subset(wine, class == 2)[, -1]
outlier(class2.wine, lim = 0, level = 0.05, option = "all")


}
\references{
Jobson, J. D.(1992). Applied Multivariate Data Analysis, Springer-Verlag, New York.
}
\seealso{
\code{\link{mardiatest}}
}
\keyword{Outliers}
