% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readNameList.R, R/readPAR.R
\name{readNameList}
\alias{readNameList}
\alias{readPAR}
\title{Read a namelist into a list}
\usage{
readNameList(datfile, namelist)

readPAR(datfile, parname, namelist = NA, fail = TRUE)
}
\arguments{
\item{datfile}{Name of the Maestra/Maespa input file (e.g. "trees.dat")}

\item{namelist}{Name of the namelist (e.g. "plot")}

\item{parname}{Name of the parameter.}

\item{fail}{Logical. If TRUE, stops with an error when parameter is not
found (if FALSE, returns NA)}
}
\value{
For \code{readPAR}, either one value, or a vector, depending on how
many values are specified for the parameter in the input file.

For \code{readNameList}, a named list.
}
\description{
Read a namelist into a list

The \code{readPAR} function reads the value of any parameter in a namelist
in one of the MAESTRA/MAESPA input files.  Also works for other text files
that have the FORTRAN namelist input structure.  Optionally specifies in
which namelist to look for the parameter.

To read an entire namelist into a list, use the \code{readNameList}
function.
}
\examples{
\dontrun{
# Read the number of trees in the plot:
readPAR("confile.dat", "notrees", "plot")

# Read the X and Y coordinates:
readPAR("confile.dat", "xycoords", "xy")

# Read entire namelist
readNameList("trees.dat", "plot")

}
}
\author{
Remko Duursma. Thanks to Andreas Ibrom for reporting a bug.
}
\seealso{
\code{\link{replacePAR}}, \code{\link{readNameList}}
}
\keyword{utilities}

