% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.mle_0.1.1.R
\name{MW.comp}
\alias{MW.comp}
\title{Parametric calculation for the Mann-Whitney effect under survival copula models}
\usage{
MW.comp(
copula = c("clayton", "gumbel", "frank", "fgm", "gb"),
copula.param = 1,
s1 = c("exponential", "weibull", "gamma", "log-normal", "burr3"),
S1.param,
s2 = c("exponential", "weibull", "gamma", "log-normal", "burr3"),
S2.param
)
}
\arguments{
\item{copula}{copula family. Available options include; "clayton", "gumbel", "frank", "fgm", "gb".}

\item{copula.param}{the copula parameter.}

\item{s1}{a parametric survival function for S1. Available options include; "exponential", "weibull", "gamma", "log-normal", "burr3".}

\item{S1.param}{the distribution parameter for S1.}

\item{s2}{a parametric survival function for S2. Available options include; "exponential", "weibull", "gamma", "log-normal", "burr3".}

\item{S2.param}{the distribution parameter for S2.}
}
\value{
estimate of the Mann-Whitney effect.
}
\description{
\code{MW.comp} provides a parametric estimator for the Mann-Whitney effect under the parametric survival functions and copulas. See Nakazono, et al.(2024) for details.
}
\details{
copula.param is restricted as below: \cr
\itemize{
\item "clayton"; copula.param >= 0
\item "gumbel"; copula.param >= 0
\item "frank"; -Inf < copula.param < Inf
\item "fgm"; -1 =< copula.param =< 1
\item "gb"; -1 =< copula.param =< 1
}
}
\examples{
# Under the exponential survival functions and Clayton copula
MW.comp(
  copula = "clayton",
  copula.param = 1,
  s1 = "exponential",
  S1.param = 1,
  s2 = "exponential",
  S2.param = 2
)


}
\references{
Nakazono, K., Lin, Y. C., Liao, G. Y., Uozumi, R., & Emura, T. (2024). Computation of the Mann–Whitney effect under parametric survival copula models. Mathematics, 12(10), 1453.
}
