% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is.wimids}
\alias{is.wimids}
\title{Checks for the \code{wimids} Class}
\usage{
is.wimids(object)
}
\arguments{
\item{object}{This argument specifies the object that should be checked to see if it is of the \code{wimids} class or not.}
}
\value{
This function returns a logical value indicating whether \code{object} is of the \code{wimids} class.
}
\description{
\code{is.wimids()} function checks whether class of objects is \code{wimids} or not.
}
\details{
The class of objects is checked to be of the \code{wimids}.
}
\examples{
\donttest{#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice::mice(osteoarthritis, m = 5)

#Estimating weights of observations in the multiply imputed datasets
weighted.datasets <- weightthem(OSP ~ AGE + SEX + BMI + RAC + SMK,
                                imputed.datasets,
                                approach = 'within',
                                method = 'glm',
                                estimand = "ATT")

#Checking the 'weighted.datasets' object
is.wimids(weighted.datasets)}
}
\seealso{
\code{\link[=weightthem]{weightthem()}}

\code{\link[=wimids]{wimids()}}
}
\author{
Farhad Pishgar
}
