% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sampler_iKernel.R
\name{sampler_MaxWiK}
\alias{sampler_MaxWiK}
\alias{sampler_MaxWiK_parallel}
\title{Function to generate parameters and simulate a model based on MaxWiK algorithm}
\usage{
sampler_MaxWiK(
  stat.obs,
  stat.sim,
  par.sim,
  model,
  arg0 = list(),
  size = 500,
  psi_t,
  epsilon,
  nmax = 100,
  include_top = FALSE,
  slowly = FALSE,
  rate = 0.2,
  n_simulation_stop = NA,
  check_err = TRUE,
  include_web_rings = TRUE,
  number_of_nodes_in_ring = 2
)

sampler_MaxWiK_parallel(
  stat.obs,
  stat.sim,
  par.sim,
  model,
  arg0 = list(),
  size = 500,
  psi_t,
  epsilon,
  nmax = 100,
  include_top = FALSE,
  slowly = FALSE,
  rate = 0.2,
  n_simulation_stop = NA,
  check_err = TRUE,
  include_web_rings = TRUE,
  number_of_nodes_in_ring = 2,
  cores = 4
)
}
\arguments{
\item{stat.obs}{Summary statistics of the observation point}

\item{stat.sim}{Summary statistics of the simulations (model output)}

\item{par.sim}{Data frame of parameters of the model}

\item{model}{Function to get output of simulation during sampling}

\item{arg0}{List with arguments for a model function, so that arg0 is NOT changed during sampling}

\item{size}{Number of points in the simulation based on MaxWiK algorithm}

\item{psi_t}{Vector of psi and t hyperparameters.}

\item{epsilon}{Criterion to stop simulation when \code{MSE_current - MSE_previous < epsilon}}

\item{nmax}{Maximal number of iterations}

\item{include_top}{Logical to include top points (network) from \code{spider_web()} function to simulate or do not}

\item{slowly}{Logical for two algorithms: slow and fast seekers in sampling}

\item{rate}{Rate value in the range \code{[0,1]} to define
the rate of changing in the original top of sampled points for slow scheme (if slowly = TRUE)}

\item{n_simulation_stop}{Maximal number of simulations to stop sampling.
If \code{n_simulation_stop = NA} then there is no restriction (by default)}

\item{check_err}{Logical parameter to check epsilon or do not}

\item{include_web_rings}{Logical to include or do not include the cobweb rings to the simulations}

\item{number_of_nodes_in_ring}{Number of points/nodes between two points in the web ring. By default \code{number_of_nodes_in_ring = 2}}

\item{cores}{Number of cores for parallel calculations of a model (4 by default)}
}
\value{
\code{sampler_MaxWiK()} returns the list: \cr
\itemize{
\item results: results of all the simulations; \cr
\item best: the best value of parameter; \cr
\item MSE_min: minimum of MSE; \cr
\item number_of_iterations: number of iterations; \cr
\item time: time of sampling in seconds, \cr
\item n_simulations: the total number of simulations.
}

\code{sampler_MaxWiK_parallel()} returns the same output as in \code{sampler_MaxWiK()}.
}
\description{
Function to generate parameters and simulate a model based on MaxWiK algorithm
}
\section{Functions}{
\itemize{
\item \code{sampler_MaxWiK_parallel()}: Function to generate parameters and simulate a model based on MaxWiK algorithm

}}
\examples{
MaxWiK::MaxWiK_templates(dir = tempdir()) # See the template 'MaxWiK.Sampling.R' 
# and vignettes for usage.
MaxWiK::MaxWiK_templates(dir = tempdir()) # See the template 'MaxWiK.Sampling.R' 
# and vignettes for usage. For parallel implementation 
# change the function 'sampler_MaxWiK()' to 'sampler_MaxWiK_parallel()'.
}
