% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_setTimeAxis.R
\name{mts_setTimeAxis}
\alias{mts_setTimeAxis}
\title{Extend/contract \emph{mts} time series to new start and end times}
\usage{
mts_setTimeAxis(mts = NULL, startdate = NULL, enddate = NULL, timezone = NULL)
}
\arguments{
\item{mts}{\emph{mts} object.}

\item{startdate}{Desired start date (ISO 8601).}

\item{enddate}{Desired end date (ISO 8601).}

\item{timezone}{Olson timezone used to interpret \code{startdate} and \code{enddate}.}
}
\value{
The incoming \emph{mts} time series object defined on a new time axis.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
Extends or contracts the time range of an \emph{mts} object by
adding/removing time steps at the start and end and filling any new time
steps with missing values. The resulting time axis is guaranteed to be
a regular, hourly axis with no gaps using the same timezone as the incoming
\emph{mts} object. This is useful when you want to place separate \emph{mts}
objects on the same time axis for plotting.

Dates can be anything that is understood by \code{MazamaCoreUtils::parseDatetime()}
including either of the following recommended formats:

\itemize{
\item{\code{"YYYYmmdd"}}
\item{\code{"YYYY-mm-dd"}}
}

Timezone determination precedence assumes that if you are passing in
\code{POSIXct} values then you know what you are doing:

\enumerate{
\item{get timezone from \code{startdate} if it is \code{POSIXct}}
\item{use passed in \code{timezone}}
\item{get timezone from \code{mts}}
}

If either \code{startdate} or \code{enddate} is missing, the start or end of
the timeseries in \code{mts} will be used.

If neither \code{startdate} nor \code{enddate} is a \code{POSIXct} value
AND no \code{timezone} is supplied, the timezone will be inferred from
the most common timezone found in \code{mts}.
}
\examples{
library(MazamaTimeSeries)

# Default range
range(example_mts$data$datetime)

# One-sided extend with user specified timezone
example_mts \%>\%
  mts_setTimeAxis(enddate = 20190815, timezone = "UTC") \%>\%
  mts_extractData() \%>\%
  dplyr::pull(datetime) \%>\%
  range()

# Two-sided extend with user specified timezone
example_mts \%>\%
  mts_setTimeAxis(20190615, 20190815, timezone = "UTC") \%>\%
  mts_extractData() \%>\%
  dplyr::pull(datetime) \%>\%
  range()

# Two-sided extend without timezone (uses timezone from mts$meta$timezone)
example_mts \%>\%
  mts_setTimeAxis(20190615, 20190815) \%>\%
  mts_extractData() \%>\%
  dplyr::pull(datetime) \%>\%
  range()

}
