% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MRConMix-class}
\alias{MRConMix-class}
\title{MRConMix Class}
\description{
An object containing the estimate produced using the contamination mixture method as well as various statistics.
}
\section{Slots}{

\describe{
\item{\code{Exposure}}{The names of the exposure variables.}

\item{\code{Outcome}}{The name of the outcome variable.}

\item{\code{Psi}}{The value of the standard deviation of the distribution of invalid estimands (default is 1.5 times the standard deviation of the ratio estimates).}

\item{\code{Estimate}}{The causal estimate from the contamination mixture method.}

\item{\code{CIRange}}{The confidence interval for \code{Estimate} based on a grid search.}

\item{\code{CILower}}{The lower limit of the confidence interval. If the confidence interval contains multiple ranges, then lower limits of all ranges will be reported.}

\item{\code{CIUpper}}{The upper limit of the confidence interval. If the confidence interval contains multiple ranges, then upper limits of all ranges will be reported.}

\item{\code{CIMin}}{The smallest value used in the search to find the confidence interval.}

\item{\code{CIMax}}{The largest value used in the search to find the confidence interval.}

\item{\code{CIStep}}{The step size used in the search to find the confidence interval.}

\item{\code{Pvalue}}{The p-value associated with the estimate calculated using the likelihood function and a chi-squared distribution.}

\item{\code{Valid}}{The numbers of genetic variants that were considered valid instruments at the causal estimate.}

\item{\code{ValidSNPs}}{The names of genetic variants that were considered valid instruments at the causal estimate.}

\item{\code{Alpha}}{The significance level used in constructing the confidence interval (default is 0.05).}

\item{\code{SNPs}}{The number of SNPs that were used in the calculation.}
}}

