% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful_functions.R
\name{wordcloud}
\alias{wordcloud}
\alias{wordcloud,MetaNLP-method}
\title{Create word cloud from MetaNLP-object}
\usage{
wordcloud(object, ...)

\S4method{wordcloud}{MetaNLP}(
  object,
  max.words = 70,
  colors = c("snow4", "darkgoldenrod1", "turquoise4", "tomato"),
  decision = c("total", "include", "exclude"),
  stop_words = FALSE,
  ...
)
}
\arguments{
\item{object}{A MetaNLP object to plot}

\item{...}{Additional parameters for \link[wordcloud]{wordcloud}}

\item{max.words}{Maximum number of words in the word cloud}

\item{colors}{Character vector with the colors in}

\item{decision}{Stratify word cloud by decision. Default is no stratification.}

\item{stop_words}{Boolean to decide whether stop words shall be included in}
}
\value{
nothing
}
\description{
This method creates a word cloud from a MetaNLP object. The word size
indicates the frequency of the words.
}
\examples{
path <- system.file("extdata", "test_data.csv", package = "MetaNLP", mustWork = TRUE)
obj <- MetaNLP(path)
plt <- plot(obj)

}
