% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2-2.manipulate.R
\name{c_net_union}
\alias{c_net_union}
\title{Union two networks}
\usage{
c_net_union(go1, go2, ...)
}
\arguments{
\item{go1}{metanet object}

\item{go2}{metanet object}

\item{...}{add}
}
\value{
metanet
}
\description{
Union two networks
}
\examples{
g1 <- make_graph(edges = c("1", 2, 2, 3, 3, 4, 4, 5, 5, 1), directed = FALSE) \%>\% as.metanet()
g2 <- make_graph(edges = c("4", 5, 5, 6, 6, 7, 7, 8, 8, 4), directed = FALSE) \%>\% as.metanet()
par(mfrow = c(1, 3))
plot(c_net_union(g1, g2))
plot(c_net_intersect(g1, g2))
plot(c_net_difference(g1, g2))
}
\seealso{
Other manipulate: 
\code{\link{anno_edge}()},
\code{\link{anno_vertex}()},
\code{\link{c_net_annotate}()},
\code{\link{c_net_filter}()},
\code{\link{c_net_load}()},
\code{\link{c_net_save}()},
\code{\link{get_e}()},
\code{\link{get_n}()},
\code{\link{get_v}()},
\code{\link{is_metanet}()}
}
\concept{manipulate}
