% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBMA_stan.R
\name{MBMA_stan}
\alias{MBMA_stan}
\title{Fitting a model-based meta-analysis model using Stan}
\usage{
MBMA_stan(
  data = NULL,
  likelihood = NULL,
  dose_response = "emax",
  mu_prior = c(0, 10),
  Emax_prior = c(0, 100),
  alpha_prior = c(0, 100),
  tau_prior = 0.5,
  tau_prior_dist = "half-normal",
  ED50_prior = c(-2.5, 1.8),
  ED50_prior_dist = "functional",
  gamma_prior = c(1, 2),
  Pred_doses,
  re = TRUE,
  ncp = TRUE,
  chains = 4,
  iter = 2000,
  warmup = 1000,
  adapt_delta = 0.95,
  ...
)
}
\arguments{
\item{data}{An object of `create_MBMA_dat`.}

\item{likelihood}{A string specifying the likelihood of distributions defining the statistical
model. Options include "normal", "binomial", and "Poisson".}

\item{dose_response}{A string specifying the function defining the dose-response model.
Options include "linear", "log-linear", "emax", and "sigmoidal".}

\item{mu_prior}{A numerical vector specifying the parameter of the normal prior
density for baseline risks, first value is parameter for mean, second is for variance.
Default is c(0, 10).}

\item{Emax_prior}{A numerical vector specifying the parameter of the normal prior
density for Emax parameter, first value is parameter for mean, second
is for standard deviation. Default is c(0, 10). Needed for emax and sigmoidal models.}

\item{alpha_prior}{A numerical vector specifying the parameter of the normal prior
density for the alpha parameter, first value is parameter for mean, second is for variance.
Default is c(0, 10). Needed for linear and linear log-dose models.}

\item{tau_prior}{A numerical value specifying the standard dev. of the prior density
for heterogenety stdev. Default is 0.5.}

\item{tau_prior_dist}{A string specifying the prior density for the heterogeneity standard deviation,
option is `half-normal` for half-normal prior, `uniform` for uniform prior, `half-cauchy` for
half-cauchy prior.}

\item{ED50_prior}{A numerical vector specifying the parameter of the normal prior
density for ED50 parameter, first value is parameter for mean, second
is for standard deviation. Default is c(0, 10). Needed for emax and sigmoidal models.}

\item{ED50_prior_dist}{A string specifying the prior density for the ED50 parameter,
`functional` is for a functional uniform prior, `half-normal` for uniform prior, `half-cauchy` for
half-cauchy prior.}

\item{gamma_prior}{A numerical vector specifying the parameter of the normal prior
density for gamma parameter, first value is parameter for mean, second
is for standard deviation. Default is c(1, 2). Needed for sigmoidal model.}

\item{Pred_doses}{A numerical vector specifying the doses which prediction will be made.}

\item{re}{A string specifying whether random-effects are included to the model. When `FALSE`, the
model corresponds to a fixed-effects model. The default is `TRUE`.}

\item{ncp}{A string specifying whether to use a non-centered parametrization.
The default is `TRUE`.}

\item{chains}{A positive integer specifying the number of Markov chains.
The default is 4.}

\item{iter}{A positive integer specifying the number of iterations for each chain
(including warmup). The default is 2000.}

\item{warmup}{A positive integer specifying the number of warmup (aka burnin)
iterations per chain. The default is 1000.}

\item{adapt_delta}{A numerical value specfying the target average proposal acceptance
probability for adaptation. See Stan manual for details. Default is 0.95. In general
you should not need to change adapt_delta unless you see a warning message about
divergent transitions, in which case you can increase adapt_delta from the
default to a value closer to 1 (e.g. from 0.95 to 0.99, or from 0.99 to 0.999, etc).}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
an object of class `stanfit` returned by `rstan::sampling`
}
\description{
`MBMA_stan` fits a model-based meta-analysis model using Stan.
}
\examples{
\dontrun{
## Load the dataset
data('dat.Eletriptan', package = "MetaStan")
datMBMA = create_MetaStan_dat(dat = dat.Eletriptan,
                              armVars = c(dose = "d",
                                          responders = "r",
                                          sampleSize = "n"),
                              nArmsVar = "nd")

MBMA.Emax  <- MBMA_stan(data = datMBMA,
                        likelihood = "binomial",
                        dose_response = "emax",
                        Pred_doses = seq(0, 80, length.out = 11),
                        mu_prior = c(0, 100),
                        Emax_prior = c(0, 100),
                        tau_prior_dist = "half-normal",
                        tau_prior = 0.5)
plot(MBMA.Emax) + ggplot2::xlab("Doses (mg)") + ggplot2::ylab("response probabilities")

}

}
\references{
Boucher M, et al. The many flavors of model-based meta-analysis:
Part I-Introduction and landmark data. \emph{CPT: Pharmacometrics and Systems Pharmacology}.
2016;5:54-64.

Guenhan BK, Roever C, Friede T. MetaStan: An R package for meta-analysis
and model-based meta-analysis using Stan. In preparation.

Mawdsley D, et al. Model-based network meta-analysis: A
framework for evidence synthesis of clinical trial data.
\emph{CPT: Pharmacometrics and Systems Pharmacology}. 2016;5:393-401.

Zhang J, et al. (2014). Network meta-analysis of randomized
clinical trials: Reporting the proper summaries. \emph{Clinical Trials}.
11(2), 246–262.

Dias S, et al. Absolute or relative effects?
Arm-based synthesis of trial data. \emph{Research Synthesis Methods}.
2016;7:23–28.
}
