% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{bootstrap}
\alias{bootstrap}
\title{Bootstrap algorithm function.}
\usage{
bootstrap(data, k, H, mtimes = 50, lr = 0.01, ncore = 2)
}
\arguments{
\item{data}{Data matrix or data frame.}

\item{k}{The number of prototypes/clusters.}

\item{H}{Matrix, input \eqn{H} matrix to start the algorithm. Usually the \eqn{H} matrix is the output of the function ssmf( ).
If \eqn{H} is not supplied, the bootstrapped \eqn{W} matrix might have different prototype orders from the outputs of the function ssmf( ).}

\item{mtimes}{Integer, number of bootstrap samples. Default number is 50.}

\item{lr}{Optimisation learning rate in ssmf().}

\item{ncore}{The number of cores to use for parallel execution.}
}
\value{
\code{W.est} The \eqn{W} matrix estimated by bootstrap.

\code{lower} Lower bound of confidence intervals.

\code{upper} Upper bound of confidence intervals.
}
\description{
Bootstrap resampling approach to estimate the confidence intervals for the cluster prototypes.
}
\details{
Create bootstrap samples of size \eqn{n} by sampling from the data set with replacement and repeat the steps \eqn{M} times.
The \eqn{m^{th}} bootstrap sample is denoted as
\deqn{X^{{\ast}(m)}=(x_1^{{\ast}(m)}, x_2^{{\ast}(m)},\ldots,x_n^{{\ast}(m)}),}

where each \eqn{x_i^{{\ast}(m)}} is a random sample (with replacement) from the data set.

Then, apply the SSMF algorithm to each bootstrap sample and calculate the \eqn{m^{th}} bootstrap replicate of the prototypes matrix,
which is denoted as \eqn{W^{{\ast}(m)}}.

The estimate standard deviation of \eqn{M} bootstrap replicates can be calculated by

\deqn{sd(W^{\ast}) =\sqrt {\frac{1}{M-1} \sum_{m=1}^{M} [W^{{\ast}(m)}-\overline{W}^{\ast}]^2 },}

where \eqn{\overline{W}^{\ast}=\frac{1}{M} \sum_{m=1}^{M} W^{{\ast}(m)}}. Therefore, the 95\% CIs for the prototypes can be calculated by

\deqn{(\overline{W}^{\ast}-t_{(0.025, M-1)} \cdot sd(W^{\ast}),\ \overline{W}^{\ast}+t_{(0.975, M-1)} \cdot sd(W^)),}
where \eqn{t_{(0.025, n-1)}} and \eqn{t_{(0.975, n-1)}} is the quantiles of student \eqn{t} distribution with 95\% significance and \eqn{(M-1)} degrees of freedom.
}
\examples{
# example code
\donttest{
data <- SimulatedDataset

k <- 4

fit <- ssmf(data = data, k = k)

bootstrap(data = data , k = k, H = fit$H)
}
}
\references{
Stine, R. (1989). An Introduction to Bootstrap Methods: Examples and Ideas. Sociological Methods & Research, 18(2-3), 243-291. <doi:10.1177/0049124189018002003>
}
\author{
Wenxuan Liu
}
