% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetabolicSurvClass.R
\name{ms}
\alias{ms}
\title{The ms class}
\usage{
ms(Result, HRRG, Group, Metnames)

ms(Result, HRRG, Group, Metnames)
}
\arguments{
\item{Result}{A list of dataframes of each output object of coxph for the metabolites.}

\item{HRRG}{A dataframe with estimated metabolite-specific HR for low risk group and 95 percent CI.}

\item{Group}{A matrix of the classification group a subject belongs to for each of the metabolite analysis. The metabolites are on the rows and the subjects are the columns}

\item{Metnames}{The names of the metabolites for the analysis}
}
\value{
object of class ms
}
\description{
The ms class

Constructor for the ms class
}
\section{Slots}{

\describe{
\item{\code{Result}}{A list of dataframes of each output object of coxph for the metabolites.}

\item{\code{HRRG}}{A dataframe with estimated metabolite-specific HR for low risk group and 95 percent CI.}

\item{\code{Group}}{A matrix of the classification group a subject belongs to for each of the metabolite analysis. The metabolites are on the rows and the subjects are the columns}

\item{\code{Metnames}}{The names of the metabolites for the analysis}
}}

\examples{
## GENERATE SOME METABOLIC SURVIVAL DATA WITH PROGNOSTIC FACTORS
Data<-MSData(nPatients=100,nMet=150,Prop=0.5)

## DO THE METABOLITE BY METABOLITE ANALYSIS
Eg = MSpecificCoxPh(Survival=Data$Survival, Mdata=t(Data$Mdata),
Censor=Data$Censor, Reduce = FALSE, Select = 15,
Prognostic=Data$Prognostic, Quantile = 0.5)

## GET THE CLASS OF THE OBJECT
class(Eg)     # An "ms" Class

##  METHOD THAT CAN BE USED FOR THIS CLASS
show(Eg)
summary(Eg)
plot(Eg)
}
\seealso{
\code{\link[MetabolicSurv]{MSpecificCoxPh}}
}
\author{
Olajumoke Evangelina Owokotomo,
\email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
