% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.new.MicrobialGrowth.core}
\alias{.new.MicrobialGrowth.core}
\title{MicrobialGrowth object}
\usage{
.new.MicrobialGrowth.core(...)
}
\arguments{
\item{...}{further arguments passed to or from other methods.}
}
\value{
a MicrobialGrowth object skeleton.
}
\description{
Provide the skeleton of the MicrobialGrowth object.
Must be completed for each model.
}
\details{
the three dots \code{...} are passed to \link[base]{new.env} function.
}
\examples{
# First, create the skeleton.
model.object = .new.MicrobialGrowth.core()

# Then complete with data, functions, etc.
model.object$data$x = c(1,2,3)
model.object$data$y = c(1,2,3)
model.object$coefficients = list(N0 = 0, Nmax=0, mu=0, lambda=0)
model.object$f$formula = function(x){ return(x) }
model.object$f$confint.lower = function(x){ return(x - 1) }
model.object$f$confint.upper = function(x){ return(x + 1) }

# Specialize the object by adding a class name at first position.
class(model.object) = c("specialized.model", class(model.object))

# You can print, plot, etc., with the generic functions of MicrobialGrowth.
print(model.object)
##MicrobialGrowth, model specialized.model:
##    N0   Nmax     mu lambda
##     0      0      0      0
plot(model.object)

# Don't forget to change `isValid` to TRUE to confirm the success of the regression.
model.object$isValid = TRUE # Not a good idea here, since we have no `reg` value.
}
