% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\name{.new.gompertz.core}
\alias{.new.gompertz.core}
\title{Gompertz object}
\usage{
.new.gompertz.core(...)
}
\arguments{
\item{...}{further arguments passed to or from other methods.}
}
\value{
a Gompertz object skeleton.
}
\description{
A MicrobialGrowth object specialized for the gompertz model.
Most of the methods are pre-implemented (some of these can be overwritten for a specific regression/create function).
Must be completed for \code{data}, \code{isValid} (regression successful), etc.
}
\details{
the three dots \code{...} are passed to the \link{.new.MicrobialGrowth.core} function.
}
\examples{
# First, create the skeleton.
model.object = .new.gompertz.core()

# Then complete with data, functions, etc.
model.object$data$x = c(1,2,3)
model.object$data$y = c(1,2,3)
model.object$coefficients = list(N0 = 0, Nmax=0, mu=0, lambda=0)

# You can print, plot, etc., with the generic functions of MicrobialGrowth.
print(model.object)
##MicrobialGrowth, model specialized.model:
##    N0   Nmax     mu lambda
##     0      0      0      0
plot(model.object)

# Don't forget to change `isValid` to TRUE to confirm the success of the regression.
model.object$isValid = TRUE # Not a good idea here, since we have no `reg` value.
}
